{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/srclicense.html.   }
{ --------------------------------------------------------------- }


procedure readpuffer;
var x,y   : byte;
    s     : pathstr;
    brk   : boolean;
    ed,pb : boolean;
    ebest : boolean;
    read  : boolean;
    useclip: boolean;
begin
  s:='*.*';
  useclip:=true;
  if ReadFilename(getres2(330,1),s,true,useclip) then   { 'Puffer einlesen' }
    if not exist(s) then
      rfehler(304)   { 'Datei nicht vorhanden!' }
    else if pos(ustr(AblagenFile),ustr(s))>0 then
      rfehler(305)   { 'Interne Ablage - bitte erst umbenennen!' }
    else begin
      dialog(46,6,fitpath(s,38),x,y);
      ed:=false; pb:=true;
      ebest:=false; read:=false;
      maddbool(3,2,getres2(330,2),ed); mhnr(101);   { 'Empfangsdatum = Erstellungsdatum' }
      maddbool(3,3,getres2(330,3),pb);     { 'Server aus Pfad bernehmen' }
      maddbool(3,4,getres2(330,4),ebest);  { 'Empfangsbesttigungen versenden' }
      maddbool(3,5,getres2(330,5),read);   { 'Nachrichten als "gelesen" markieren' }
      readmask(brk);
      closemask;
      closebox;
      if not brk then
        if puffereinlesen(s,iifs(pb,'',DefaultBox),ed,false,ebest,
                          iif(read,pe_gelesen,0)) then;
      if useclip then _era(s);
      end;
  freeres;
end;


{ Pollbox='' -> Pollbox wird aus Pfad bernommen, falls vor-  }
{               handen, sonst aus DefaultBox                  }
{ Replace-ED :  Empfangsdatum durch Erstellungsdatum ersetzen }

function  PufferEinlesen(puffer:pathstr; pollbox:string; replace_ed,
                         sendbuf,ebest:boolean; pflags:word):boolean;

const bufsize  = 30000;
      maxll    = 64;

var x,y,fm   : byte;
    f,pfile  : file;
    llbuf    : array[1..maxll] of longint;
    llanz    : integer;
    padr,size: longint;
    ablage   : byte;
    abadd    : byte;
    p        : charrp;
    adr,fs,l : longint;
    hdp      : headerp;
    i        : integer;
    hdsize   : longint;
    rr       : word;
    dat      : string[11];
    tobrett  : boolean;
    typ1     : char;
    ok       : boolean;
    name     : string[AdrLen];
    adrbuch  : byte;
    flags,atp: byte;
    pb       : string[20];
    grnr     : longint;
    _brett   : string[5];
    ld       : longint;
    uflags   : byte;
    aufnehmen: boolean;
    diff     : integer;
    d        : DB;
    haltezeit: integer;
    MsgCount : longint;
    brettlog,
    userlog  : text;
    _datum   : longint;
    mapsname : string[20];
    check    : boolean;
    seekbr   : string[BrettLen];
    p0       : byte;
    zconnect : boolean;
    pm       : boolean;
    mnt      : longint;       { Netztyp-Feld fr mbase }
    msgid2   : string[19];    { gekrzte MsgID (FormMsgid) fr mbase }
    today    : longint;
    empfnr   : integer;
    junk     : boolean;
    msgsent  : boolean;
    amvertreter,
    pmvertreter : string[BoxnameLen];
    forcepfadbox: boolean;
    sysbetreff  : string[50];  { Betreff von Changesys/getsys }
    IsGelesen   : boolean;
    cancelfile  : text;
    cancels     : integer;
    orgempf  : string[AdrLen];

  function puffer_ok:boolean;
  var ok : boolean;
  begin
    moff;
    writeln;
    write(getres(331));    { 'Puffer berprfen...' }
    mon;
    MsgCount:=0; adr:=0;
    repeat
      inc(MsgCount);
      if MsgCount mod 10=0 then begin
        moff; write(MsgCount:6,#8#8#8#8#8#8); mon; end;
      seek(f,adr);
      makeheader(zconnect,f,0,0,hdsize,hdp^,ok,true);
      inc(adr,hdsize+hdp^.groesse);
    until not ok or (adr>=fs-3);     { Der Puffer kann maximal 3 zustzliche }
    moff;
    if MsgCount>1 then writeln(MsgCount:6)     { Zeichen enthalten, die      }
    else writeln;                              { weggeschluckt werden.       }
    mon;
    puffer_ok:=ok and (adr<=fs+8);
    diff:=min(maxint,max(0,fs-adr));
  end;

{
  procedure writemsg;
  var size : longint;
      rr   : word;
  begin
    dbWriteN(mbase,mb_ablage,ablage);
    dbWriteN(mbase,mb_adresse,padr);
    size:=hdp^.groesse+hdsize;
    dbWriteN(mbase,mb_msgsize,size);
    blockwrite(pfile,p^,min(readfirst,hdsize+hdp^.groesse));
    dec(size,readfirst);
    if size>0 then begin
      repeat
        blockread(f,p^,min(bufsize,size),rr);
        blockwrite(pfile,p^,rr);
        dec(size,rr);
      until size=0;
    end;
    inc(padr,hdp^.groesse+hdsize);
  end;
}

  function pollbox_str(zconnect,user:boolean):string;
  begin
    if not user and (amvertreter<>'') then
      pollbox_str:=amvertreter
    else if user and (pmvertreter<>'') then
      pollbox_str:=pmvertreter
    else if not forcepfadbox and (pollbox<>'') then
      pollbox_str:=pollbox
    else if trim(hdp^.pfad)='' then
      pollbox_str:=DefaultBox
    else
      pollbox_str:=pfadbox(zconnect,hdp^.pfad);
  end;

  function adrok(var s:string):boolean;
  begin
    adrok:=(useraufnahme=0) or
           ((useraufnahme=1) and (pm or ((pos('%',s)=0) and (pos(':',s)=0)))) or
           ((useraufnahme=3) and pm);
  end;

  procedure showbetreff;
  begin
    mwrt(52,wherey,forms(hdp^.betreff,23));
  end;

  procedure wwin;
  begin
    window(x+2,y+1,x+76,y+screenlines-8);
  end;

  function isl(s:string):boolean;
  begin
    isl:=left(hdp^.betreff,length(s))=s;
  end;

  procedure w0;
  begin
    savecursor;
    window(1,1,80,25);
  end;

  procedure w1;
  begin
    wwin;
    restcursor;
  end;

  function LeftAbsender(s:string):boolean;
  begin
    LeftAbsender:=(left(lstr(hdp^.absender),length(s)+1+length(pollbox))=lstr(s+'@'+pollbox));
  end;

  procedure CancelMsg(var id,abs:string);
  var crc  : longint;
      hdp2 : headerp;
      hds  : longint;
      rec  : longint;
      mrec : longint;

    procedure DelMsg;
    var b : byte;
    begin
      b:=1;  dbWriteN(mbase,mb_gelesen,b);
      b:=2;  dbWriteN(mbase,mb_halteflags,b);   { gelscht }
      dbReadN(mbase,mb_unversandt,b);
      b:=b or 128;   { gecancelt }
      dbWriteN(mbase,mb_unversandt,b);
    end;

  begin
    if (pos(reverse('nolybab!'),hdp^.pfad)>0) or
       (pos(reverse('lebabr!'),hdp^.pfad)>0) then
      exit;
    if left(id,1)='<' then delfirst(id);
    if right(id,1)='>' then dellast(id);
    if cpos('@',id)=0 then exit;
    crc:=CRC32(id);
    dbSeek(bezbase,beiMsgId,dbLongStr(crc));
    if dbFound then begin
      new(hdp2);
      hdp2^.msgid:='';
      mrec:=dbRecno(mbase);
      repeat
        rec:=dbReadInt(bezbase,'MsgPos');
        if not dbDeleted(mbase,rec) then begin   { sicher ist sicher.. }
          dbGo(mbase,rec);
          Readheader(hdp2^,hds,false);
          end;
        dbNext(bezbase);
      until (hdp2^.msgid=id) or dbEOF(bezbase) or (dbReadInt(bezbase,'msgid')<>crc);
      if (hdp2^.msgid=id) and (hdp2^.absender=abs) then DelMsg;
      dbGo(mbase,mrec);
      dispose(hdp2);
      end;
    DelMsg;   { Cancel-Nachricht auf 'gelesen' / 'lschen' }
  end;

  procedure cancelmsgs;
  var id : string[MidLen];
      abs: string[AdrLen];
      n  : longint;
      rec: longint;
  begin
    moff; writeln; mon;
    reset(cancelfile);
    n:=0;
    while not eof(cancelfile) do begin
      inc(n);
      moff;
      write(#13,getres(341),n);
      mon;
      readln(cancelfile,rec);
      dbGo(mbase,rec);
      readln(cancelfile,id);
      readln(cancelfile,abs);
      CancelMsg(id,abs);
      end;
    close(cancelfile);
    moff; writeln; mon;
  end;

  function IsCancelMsg:boolean;
  begin
    with hdp^ do
      IsCancelMsg:=(attrib and attrControl<>0) and (lstr(left(betreff,7))='cancel ');
  end;

  function IsSupportCfg:boolean;

    function NameOk:boolean;
    begin
      NameOk:=stricmp(hdp^.realname,inout.pm) or
              (pos(lstr(inout.pm),lstr(hdp^.absender))>0);
    end;

    function XPctlOk:boolean;
    var sum : longint;
        i   : integer;
    begin
      with hdp^ do begin
        sum:=0;
        for i:=1 to length(datum) do
          inc(sum,ord(datum[i])*7);
        for i:=1 to length(msgid) do
          inc(sum,ord(msgid[i])*3);
        XpCtlOk:=(sum=XpointCtl div 1000);
        end;
    end;

  begin
    with hdp^ do
      IsSupportCfg:=
        (ntXPctl(netztyp) and NameOk and XPctlOk) or
        ((netztyp=nt_Maus) and (absender=inout.pm+'@LU') and
         (left(betreff,11)=SupportCfg));
  end;

  procedure TestControlMessage;
  var box    : string[20];
      fstype : byte;
  begin
    automessaging:=true;
    with hdp^ do begin
      if aufnehmen and
        ( ((left(ustr(betreff),7)='BRETTER') or
           (pos('your list',lstr(betreff))>0))
         and
         stricmp(left(absender,length(mapsname)),mapsname) and
         (empfaenger[1]='1') )
      or
         ((left(absender,7)='SYSTEM@') and
          ((left(ustr(betreff),11)='NETZBRETTER') or  { QuickMail }
           (ustr(betreff)='BESTELLBARE BRETTER')  or  { G & S     }
           (pos('BRETTLISTE',ustr(betreff))>0)))      { TurboBox, ZQWK }
          then begin
        showbetreff;
        w0;
        MapsReadList;
        w1;
        end;

      if (left(ustr(betreff),6)='FILES.') and (cpos('@',absender)>0) and
         (typ='T') then
      begin
        box:=copy(absender,cpos('@',absender)+1,20);
        if cpos('.',box)>0 then begin
          box:=left(box,cpos('.',box)-1);
          if IsServer(box,fstype) and (fstype<>3) then begin
            showbetreff;
            w0;
            FS_Readlist(true);
            w1;
            end;
          end;
        end;

      if (empfaenger[1]='1') { PM } and empfbest and ebest and
         (((attrib and attrReqEB<>0) and (attrib and attrIsEB=0)) or
          ((empfbkennung<>'') and (isl(empfbkennung) or
            isl(QPC_ID+empfbkennung) or isl(DES_ID+empfbkennung)))) then
      begin
        showbetreff;
        w0;
        empfang_bestaetigen(pollbox);
        w1;
        end;

      if (sysbetreff<>'') and (empfaenger[1]='1') and (lstr(betreff)=sysbetreff) and
         (LeftAbsender('changesys') or LeftAbsender('news') or
          LeftAbsender('postmaster') or LeftAbsender('root')) then
      begin
        showbetreff;
        w0;
        GetSysfile;
        w1;
        end;

      if UsePGP and (empfaenger[1]='1') { PM } and
         (pgpflags and fPGP_request<>0) and ebest then begin
        if pollbox<>'' then
          xp6.forcebox:=pollbox
        else
          xp6.forcebox:=pfadbox(true,pfad);
        xp6._bezug:=msgid;
        xp6._beznet:=netztyp;
        w0;
        PGP_SendKey(iifs(pgp_uid='',absender,pgp_uid));
        w1;
        xp6.forcebox:='';
        end;

      if IsCancelMsg then begin
        showbetreff;
        w0;
        writeln(cancelfile,dbRecno(mbase));
        writeln(cancelfile,trim(mid(betreff,8)));
        writeln(cancelfile,absender);
        inc(cancels);
        w1;
        end;

      if IsSupportCFG then begin
        showbetreff;
        w0;
        XRead(SupportCfg,false);
        w1;
        end;
      end;
    automessaging:=false;
  end;

  function logstr(s:string):string;
  begin
    logstr:=left(date,6)+right(date,2)+' '+left(time,5)+' '+s;
  end;

  procedure pmCryptDecode;
  var passwd,s : string;
      size     : word;
      codierer : byte;
      f,f2     : file;
      tmp      : pathstr;
      t        : text;
      uncfile  : pathstr;
      uvs      : byte;
      hdp2     : headerp;
      hds2     : longint;
      p        : pointer;
      rr       : word;
      i        : integer;
      ok       : boolean;
      orgsize  : longint;
      orgempf  : AdrStr;
  begin
    size:=0;
    dbSeek(ubase,uiName,ustr(hdp^.absender));
    if not dbFound then exit;
    dbReadX(ubase,'passwort',size,passwd);
    dbRead(ubase,'codierer',codierer);
    if (passwd='') or (codierer<3) or (codierer>2+maxpmc) or
      (TempFree<2*dbReadInt(mbase,'msgsize')) then exit;
    new(hdp2);
    ReadHeader(hdp2^,hds2,true);
    assign(f,temppath+cryptedfile);
    rewrite(f,1);
    XreadF(dbReadInt(mbase,'msgsize')-dbReadInt(mbase,'groesse'),f);
    close(f);
    uncfile:=temppath+uncryptedfile;
    s:=pmcrypt[codierer-2].decode;
    rps(s,'$KEY',passwd);
    rps(s,'$INFILE',temppath+cryptedfile);
    rps(s,'$OUTFILE',uncfile);
    rps(s,'$USER',hdp^.absender);
    if exist(uncfile) then _era(uncfile);
    savecursor;
    window(1,1,80,25);
    shell(s,600,3);                     { Nachricht decodieren }
    if existf(f) then erase(f);       { codierte Msg lschen, falls noch da }
    if not exist(uncfile) then
      trfehler(306,5)         { 'Fehler beim Decodieren' }
    else begin
      assign(f,uncfile);
      reset(f,1);
      makeheader(false,f,0,0,hds2,hdp2^,ok,false);
      close(f);
      if not ok then
        trfehler(306,5)       { 'Fehler beim Decodieren' }
      else begin
        reset(f,1);   { uncfile }
        hdp^.betreff:=hdp2^.betreff;
        hdp^.typ:=hdp2^.typ;
        orgsize:=hdp^.groesse;     hdp^.groesse:=filesize(f)-hds2;  { = hdp2^.groesse }
        orgempf:=hdp^.empfaenger;  hdp^.empfaenger:=hdp2^.empfaenger;
        tmp:=TempS(hdp^.groesse+2048);
        assign(f2,tmp);
        rewrite(f2,1);
        ClearPGPflags(hdp);
        WriteHeader(hdp^,f2,reflist);    { neuer Header }
        seek(f,hds2);
        fmove(f,f2);                     { + decodierter Text }
        close(f); close(f2);
        erase(f);   { uncfile }
        Xwrite(tmp);
        wrkilled;
        _era(tmp);
        dbWriteN(mbase,mb_betreff,hdp2^.betreff);
        dbWriteN(mbase,mb_typ,hdp2^.typ[1]);
        dbWriteN(mbase,mb_groesse,hdp^.groesse);
        dbReadN(mbase,mb_unversandt,uvs);
        uvs:=uvs or 4;                        { "c"-Flag }
        dbWriteN(mbase,mb_unversandt,uvs);
        hdp^.groesse:=orgsize;
        hdp^.empfaenger:=orgempf;
        end;
      end;
    wwin;
    restcursor;
    dispose(hdp2);
  end;

  procedure DecPGP;
  var s : string[AdrLen];
  begin
    s:=hdp^.empfaenger;
    hdp^.empfaenger:=orgempf;
    attrtxt(col.colmboxhigh);
    showbetreff;
    savecursor;
    window(1,1,80,25);
    LogPGP(getreps2(3002,2,hdp^.absender));  { 'decodiere Nachricht von %s' }
    PGP_DecodeMessage(hdp,false);
    wwin;
    restcursor;
    hdp^.empfaenger:=s;
  end;

  procedure wrp;
  var ps : string[3];
  begin
    w0;
    ps:=strs(inmsgs*100 div msgcount);
    gotoxy(x+73-length(ps),y);
    moff;
    write(' ',ps,'% ');
    mon;
    w1;
  end;

  procedure Bezugsverkettung;
  var n,nbez : longint;
      c1,c2  : longint;
      ll     : record
                 l   : longint;
                 dat : longint;
               end;
      empfnr : integer;
      xx     : byte;
  begin
    moff;
    writeln;
    write(getres(332));   { 'Bezugsverkettung...' }
    xx:=wherex+1;
    mon;
    reset(f,1);
    fs:=filesize(f);
    adr:=0; n:=0; nbez:=0;
    dbStopHU(bezbase);
    seek(pfile,0);
    repeat
      empfnr:=1;
      inc(n);
      repeat
        seek(f,adr);
        makeheader(zconnect,f,empfnr,0,hdsize,hdp^,ok,true);
        if hdp^.empfanz>maxcrosspost then begin
          empfnr:=hdp^.empfanz+1;                { Crossposting-Filter }
          continue;
          end;
        blockread(pfile,ll,8);
        if (ll.l<>0) and ntKomkette(hdp^.netztyp) and (hdp^.msgid<>'') then begin
          inc(nbez);
          c1:=CRC32(hdp^.msgid);
          if hdp^.ref='' then c2:=0
          else c2:=CRC32(hdp^.ref);
          dbAppend(bezbase);
          dbWriteN(bezbase,bezb_msgpos,ll.l);
          dbWriteN(bezbase,bezb_msgid,c1);
          dbWriteN(bezbase,bezb_ref,c2);
          dbWriteN(bezbase,bezb_datum,ll.dat);
          end;
        inc(empfnr);
      until empfnr>hdp^.empfanz;
      gotoxy(xx,wherey);
      moff;
      write(nbez,' (',n*100 div msgcount,'%) ');
      mon;
      inc(adr,hdp^.groesse+hdsize);
    until adr>=fs-3;     { 3 Byte Toleranz }
    dbRestartHU(bezbase);
    dbFlush(bezbase);
    close(f);
    writeln;
  end;

  procedure wrll(l:longint);
  begin
    inc(llanz);
    llbuf[llanz]:=l;
    if llanz=maxll then begin
      blockwrite(pfile,llbuf,sizeof(llbuf));
      llanz:=0;
      end;
  end;

  function IsOwnDomain(dom:string):boolean;
  var p : DomainNodep;
  begin
    if cpos('@',dom)=0 then
      IsOwnDomain:=false
    else begin
      delete(dom,1,cpos('@',dom));
      LoString(dom);
      p:=DomainList;
      while (p<>nil) and (p^.domain^<>dom) do
        if dom<p^.domain^ then p:=p^.left
        else p:=p^.right;
      IsOwnDomain:=(p<>nil);
      end;
  end;

  procedure FlushLL;
  begin
    if llanz>0 then begin
      blockwrite(pfile,llbuf,llanz*4);
      llanz:=0;
      end;
  end;

begin
  inmsgs:=0;
  puffereinlesen:=false;
  forcepfadbox:=(pflags and pe_ForcePfadbox<>0);
  msgbox(78,screenlines-6,getres(333),x,y);    { 'Puffer einlesen' }
  wwin;
  attrtxt(col.colmbox);
  zconnect:=ZC_puffer(puffer);
  assign(f,puffer);
  reset(f,1);
  fs:=filesize(f);
  if fs<16 then begin
    close(f);
    moff;
    writeln(#10,getres(334));    { 'leerer Puffer' }
    mon;
    wkey(1,false);
    closebox;
    puffereinlesen:=true;
    exit;
    end;
  check:=(fs*1.3<diskfree(0));

  getmem(p,bufsize);
  new(hdp);
  if check and puffer_ok then begin
    abadd:=iif(zconnect,10,0);
    l:=ablsize[1+abadd]; ablage:=1+abadd;   { 0/10 = PM-Ablage }
    for i:=2+abadd to 9+abadd do
      if ablsize[i]<l then begin
        ablage:=i; l:=ablsize[i];
        end;

    assign(brettlog,logpath+brettLogfile);
    if existf(brettlog) then append(brettlog)
    else rewrite(brettlog);
    assign(userlog,logpath+userLogfile);
    if existf(userlog) then append(userlog)
    else rewrite(userlog);

    if pollbox='' then begin
      mapsname:='MAPS'; amvertreter:=''; pmvertreter:='';
      sysbetreff:='';
      end
    else begin
      dbOpen(d,BoxenFile,1);
      dbSeek(d,boiName,ustr(pollbox));
      if not dbFound then begin
        mapsname:=''; amvertreter:=''; pmvertreter:='';
        sysbetreff:='';
        end
      else begin
        dbRead(d,'nameomaps',mapsname);
        dbRead(d,'AVertreter',AMvertreter);
        dbRead(d,'PVertreter',PMvertreter);
        dbSeek(d,boiName,ustr(amvertreter));
        if not dbFound then amvertreter:='';
        dbSeek(d,boiName,ustr(pmvertreter));
        if not dbFound then pmvertreter:='';
        dbSeek(d,boiname,ustr(pollbox));
        if dbReadInt(d,'netztyp')=nt_UUCP then begin
          ReadBoxPar(nt_UUCP,pollbox);
          sysbetreff:=lstr(boxpar^.chsysbetr);
          end;
        end;
      dbClose(d);
      end;

    moff; writeln(getres(335)); mon;    { 'Puffer kopieren...' }
    assign(pfile,aFile(ablage));        { Puffer in die kleinste }
    if existf(pfile) then begin         { Ablage kopieren ..     }
      reset(pfile,1);
      padr:=filesize(pfile);
      seek(pfile,padr);
      end
    else begin
      rewrite(pfile,1);
      padr:=0;
      end;
    seek(f,0);
    size:=filesize(f)-diff;
    repeat
      blockread(f,p^,bufsize,rr);
      blockwrite(pfile,p^,rr);
      dec(size,rr);
    until eof(f);
    close(pfile);

    assign(pfile,TempS(msgcount*8+2048));
    rewrite(pfile,1);
    llanz:=0;
    seek(f,0);
    assign(cancelfile,TempS(msgcount*40+2048));
    rewrite(cancelfile);
    cancels:=0;

    adr:=0;
    dat:=Zdate;
    today:=ixDat(dat);
    dbStopHU(mbase);
    repeat
      empfnr:=1;
      junk:=false;
      msgsent:=false;       { true -> Nachricht wurde in mind. einem Brett gespeichert }
      repeat       { Cross-Postings bearbeiten }
        seek(f,adr);
        makeheader(zconnect,f,empfnr,0,hdsize,hdp^,ok,true);
        orgempf:=hdp^.empfaenger;
        if hdp^.empfanz>maxcrosspost then begin
          empfnr:=hdp^.empfanz+1;                { Crossposting-Filter }
          continue;
          end;
        if junk then begin
          hdp^.empfanz:=1;
          hdp^.empfaenger:='/Junk';
          end;
        if grosswandeln and not zconnect then begin
          UpString(hdp^.absender);
          UpString(hdp^.empfaenger);
          end;
        pm:=false;
        with hdp^ do begin
          if replace_ed then dat:=datum;
          _datum:=ixdat(dat);
          if replace_ed and smdl(today,_datum) then begin
            dat:=zdate;
            _datum:=today;
            end;
          tobrett:=archive or (copy(empfaenger,1,TO_len)=TO_ID);
          atp:=pos('@',empfaenger);
          if sendbuf then begin   { pollbox <> '' !  }
            if (left(empfaenger,1)<>'/') and (cpos('@',empfaenger)=0) then
              empfaenger:=empfaenger+'@'+pollbox+'.ZER';
            if cpos('@',empfaenger)>0 then
              if tobrett then
                empfaenger:='U'+mid(empfaenger,iif(archive,1,length(TO_ID)+1))
              else begin
                empfaenger:='U'+empfaenger;
                tobrett:=true;
                end
            else
              empfaenger:='A'+empfaenger;
            end
          else     { not sendbuf }
            if tobrett then
              if (copy(empfaenger,1,9)<>'/'#0#0#8#8'TO:/') or (atp>0) then
                empfaenger:='U'+copy(empfaenger,iif(archive,1,9),79)
              else begin
                while empfaenger[10]=#255 do  { wg. #255#255'Netzanruf' }
                  delete(empfaenger,10,1);
                empfaenger:='$/'+copy(empfaenger,10,255);
                end
            else
              if empfaenger[2]='' then
                empfaenger:='$'+empfaenger
              else
                if (atp=0) and (left(empfaenger,1)='/') then
                  empfaenger:='A'+empfaenger
                else begin
                  if atp=0 then empfaenger:='1/'+empfaenger
                  else
                    if UserBoxname then
                      empfaenger:='1/'+left(empfaenger,atp-1)+'/'+mid(empfaenger,atp+1)
                    else
                      empfaenger:='1/'+left(empfaenger,atp-1);
                  pm:=true;
                  end;
          moff;
          writeln;
          if empfaenger[1]='U' then begin
            write('AN:'); fm:=24; end
          else
            fm:=27;
          write(forms(copy(empfaenger,2,40),fm),' ',forms(absender,22),' ',forms(betreff,23));
          mon;
          multi2(curoff); initscs;

          attrtxt(col.colmboxhigh);
          dbSeek(ubase,uiName,ustr(absender));
          if not dbFound then begin          { neuen User anlegen }
            if adrok(absender) then begin
              mwrt(29,wherey,forms(absender,22));
              dbAppend(ubase);
              dbWrite(ubase,'username',absender);
              pb:=pollbox_str(zconnect,true);
              dbWrite(ubase,'pollbox',pb);
              dbWrite(ubase,'haltezeit',stduhaltezeit);
              flags:=1+iif(ntUserIBMchar(netztyp),0,8);  { aufnehmen / Umlaute }
              dbWrite(ubase,'userflags',flags);
              writeln(userlog,logstr(absender));
              end;
            aufnehmen:=true;
            end
          else
            if empfaenger[1]<>'A' then
              aufnehmen:=true
                         { not developer or
                         ((pos('@mips.pfalz.de',absender)=0) and
                          (pos('news@pythia.lunetix.de',absender)=0) and
                          (pos('news@dfki.uni-sb.de',absender)=0)) }
            else begin
              dbReadN(ubase,ub_userflags,uflags);
              aufnehmen:=odd(uflags);
              end;
          if left(empfaenger,1)<>'U' then begin
            dbSeek(bbase,biBrett,ustr(empfaenger));
            if not dbFound then begin
              if (empfanz>1) or (attrib and AttrControl<>0) then
                aufnehmen:=false
              else if aufnehmen then begin          { neues Brett anlegen }
                mwrt(1,wherey,forms(copy(empfaenger,2,27),27));
                if left(empfaenger,1)<>'A' then grnr:=IntGruppe
                else begin
                  seekbr:=empfaenger;
                  p0:=posn('/',seekbr,3);
                  if p0>0 then begin
                    seekbr:=left(seekbr,p0-1);
                    if dbEOF(bbase) or
                       (left(dbReadStr(bbase,'brettname'),length(seekbr))<>seekbr) then
                      dbSeek(bbase,biBrett,ustr(seekbr));
                    end;
                  if dbEOF(bbase) then dbGoEnd(bbase);
                  if dbEOF(bbase) then grnr:=NetzGruppe
                  else dbReadN(bbase,bb_gruppe,grnr);
                  if grnr=IntGruppe then grnr:=NetzGruppe;
                  end;
                if left(empfaenger,1)='1' then
                  haltezeit:=0
                else begin
                  dbOpen(d,GruppenFile,1);
                  dbSeek(d,giIntnr,dbLongStr(grnr));
                  if not dbFound then haltezeit:=stdhaltezeit
                  else dbRead(d,'haltezeit',haltezeit);
                  dbClose(d);
                  end;
                dbAppend(bbase);
                dbWriteN(bbase,bb_brettname,empfaenger);
                pb:=pollbox_str(zconnect,false);
                dbWriteN(bbase,bb_pollbox,pb);
                dbWriteN(bbase,bb_haltezeit,haltezeit);
                dbWriteN(bbase,bb_gruppe,grnr);
                flags:=iif(netztyp=nt_UUCP,16,0);
                dbWriteN(bbase,bb_flags,flags);
                if newbrettende then
                  SetBrettindexEnde
                else begin
                  w0;
                  SetBrettindex;
                  w1;
                  end;
                writeln(brettlog,logstr(copy(empfaenger,2,255)));
                end;   { aufnehmen }
              end    { not dbFound }
            else
              if dbReadInt(bbase,'flags') and 4<>0 then aufnehmen:=true;
            if aufnehmen then
              _brett:=mbrettd(empfaenger[1],bbase);
            end;
          { hier kein adrok: TO-User werden immer aufgenommen! }
          if left(empfaenger,1)='U' then begin
            dbSeek(ubase,uiName,ustr(copy(empfaenger,2,80))); {Adrebuch-Eintrag}
            if not dbFound then begin
              dbAppend(ubase);
              name:=copy(empfaenger,2,79);
              pb:=pollbox_str(zconnect,true);
              if pos('@',name)=0 then name:=left(name+'@'+pb+'.ZER',79);
              dbWriteN(ubase,ub_username,name);
              dbWriteN(ubase,ub_pollbox,pb);
              dbWriteN(ubase,ub_haltezeit,stduhaltezeit);
              flags:=1;  { aufnehmen }
              dbWrite(ubase,'userflags',flags);
              adrbuch:=1;
              dbWriteN(ubase,ub_adrbuch,adrbuch);
              end
            else begin
              dbReadN(ubase,ub_adrbuch,adrbuch);
              if adrbuch=0 then begin
                adrbuch:=1;
                dbWriteN(ubase,ub_adrbuch,adrbuch);
                end;
              end;
            _brett:=mbrettd('U',ubase);
            end;

          IsGelesen:=ParGelesen or sendbuf or
                     ((netztyp=nt_Maus) and (left(pm_bstat,1)='G')) or
                     (filterattr and fattrGelesen<>0) or
                     (pflags and pe_gelesen<>0);

          if aufnehmen then begin
            if left(empfaenger,1)<>'U' then begin
              dbReadN(bbase,bb_flags,flags);
              if not IsGelesen and (flags and 2 = 0) then
              begin
                inc(flags,2);                 { ungelesene Nachricht(en) }
                dbWriteN(bbase,bb_flags,flags);
                end;
              if _datum>dbReadInt(bbase,'ldatum') then
                dbWriteN(bbase,bb_ldatum,_datum);      { Datum der neuesten Msg }
              end;
            dbAppend(mbase);
            mnt:=netztyp;
            if ref<>'' then inc(mnt,$100);
            if attrib and attrFile<>0 then inc(mnt,$200);
            if pm_reply then inc(mnt,$400);
            if (wab<>'') or (oem<>'') then inc(mnt,$800);
            if empfanz>1 then inc(mnt,longint(empfnr) shl 24);
            if ((empfaenger[1]='A') and ntDomainReply(netztyp) and
                IsOwnDomain(ref)) or
               (filterattr and fattrHilite<>0)
            then begin
              attrtxt(col.colmboxhigh);
              showbetreff;
              attrtxt(col.colmbox);
              inc(mnt,$1000);        { Antwort auf eigene Nachricht }
              end;
            if charset='iso1' then inc(mnt,$2000);
            if komlen>0 then inc(mnt,$8000);
            dbWriteN(mbase,mb_netztyp,mnt);
            dbWriteN(mbase,mb_betreff,betreff);
            dbWriteN(mbase,mb_absender,absender);
            ld:=ixdat(datum);
            dbWriteN(mbase,mb_origdatum,ld);
            ld:=ixdat(dat);
            dbWriteN(mbase,mb_empfdatum,ld);
            dbWriteN(mbase,mb_groesse,groesse);
            typ1:=UpCase(typ[1]);
            if (typ1<=' ') or (typ1>#126) then typ1:='?';
            dbWriteN(mbase,mb_typ,typ1);
            dbWriteN(mbase,mb_brett,_brett);
            dbWriteN(mbase,mb_ablage,ablage);
            dbWriteN(mbase,mb_adresse,padr);
            size:=groesse+hdsize;
            dbWriteN(mbase,mb_msgsize,size);
            msgid2:=FormMsgid(msgid);
            dbWriteN(mbase,mb_msgid,msgid2);
            if ntEditBrettempf(netztyp) then   { Fido, QWK }
              dbWriteN(mbase,mb_name,fido_to)
            else
              dbWriteN(mbase,mb_name,realname);
            if IsGelesen then begin
              flags:=1;
              dbWriteN(mbase,mb_gelesen,flags);
              if sendbuf then dbWriteN(mbase,mb_unversandt,flags);
              end;
            flags:=0;
            if filterattr and fattrLoeschen<>0 then flags:=2;
            if filterattr and fattrHalten<>0 then flags:=1;
            dbWriteN(mbase,mb_halteflags,flags);
            wrll(dbRecno(mbase));     { fr Bezugsverkettung merken }
            l:=ixdat(datum) and $fffffff0;
            if empfanz>1 then
              inc(l,iif(msgsent,2,1));
            wrll(l);

            if UsePGP and (pgpflags and fPGP_haskey<>0) and
               ((PGP_AutoAM and (firstchar(empfaenger)='A')) or
                (PGP_AutoPM and (firstchar(empfaenger)='1')))
            then begin
              attrtxt(col.colmboxhigh);
              showbetreff;
              savecursor;
              window(1,1,80,25);
              PGP_ImportKey(true);
              wwin;
              restcursor;
              end;
            if (firstchar(empfaenger)='1') and UsePGP and
               (pgpflags and fPGP_encoded<>0) then
              DecPGP else
            if (firstchar(empfaenger)='1') and
               (left(betreff,length(PMC_ID))=PMC_ID) then begin
              attrtxt(col.colmboxhigh);
              showbetreff;
              pmCryptDecode;
              attrtxt(col.colmboxhigh);
              showbetreff;
              end;

            msgsent:=true;
            end
          else begin   { nicht aufnehmen }
            wrll(0);
            wrll(0);
            gotoxy(wherex,wherey-1);
            end;

          inc(empfnr);
          end;           { with hdp^ }
        if msgsent then begin
          attrtxt(col.colmboxhigh);
          TestControlMessage;
          end;
        attrtxt(col.colmbox);
        if (hdp^.empfanz>1) and (empfnr>hdp^.empfanz) and not msgsent and
           not IsCancelMsg then begin
          { Nachricht nach /Junk }
          junk:=true;
          empfnr:=1;            { kein passendes Brett fr Crossposting }
          FlushLL;
          seek(pfile,filesize(pfile)-8);
        { seek(pfile,filesize(pfile)-8*hdp^.empfanz); }
        { seek(pfile,filesize(pfile)-4*max(0,2*hdp^.empfanz-llanz));
          llanz:=max(0,llanz-2*hdp^.empfanz); }
          end;
    (*  else
          if junk then begin
            FlushLL;
            seek(pfile,sizeof(pfile));   { 0/0-Eintrge fr nicht einsor- }
            end;                         { tierte Xpostings berspringen  } *)
      until empfnr>hdp^.empfanz;

      inc(adr,hdp^.groesse+hdsize);
      inc(padr,hdp^.groesse+hdsize);
      inc(inmsgs);
      wrp;
    until adr>=fs-3;     { 3 Byte Toleranz }
    dbrestartHU(mbase);
    dbFlush(mbase);
    close(f);
    inc(ablsize[ablage],fs);

    moff;
    writeln;
    if not aufnehmen then writeln;
    mon;
    FlushLL;
    if zconnect then
      Bezugsverkettung;
    close(pfile);
    erase(pfile);
    close(cancelfile);
    if cancels>0 then
      CancelMsgs;
    erase(cancelfile);

    if not replace_ed then write_lastcall(dat);
    FlushClose;
    close(brettlog);
    close(userlog);
    puffereinlesen:=true;
    end   { if Puffer_ok }

  else begin
    close(f);
    moff;
    writeln;
    attrtxt(col.colmboxhigh);
    writeln(getres2(336,1));    { 'ACHTUNG !!!' }
    writeln;
    if check then
      writeln(getres2(336,2)+ustr(puffer))   { 'Fehlerhafte Pufferdatei:  ' }
    else
      writeln(getres2(336,3));    { 'Zu wenig Platz auf der Festplatte.' }
    writeln(getres2(336,4));      { 'Puffer wurde NICHT eingelesen!' }
    if pflags and pe_Bad<>0 then begin
      MoveToBad(puffer);
      writeln;
      writeln(getres2(336,5));    { 'Datei wurde im Unterverzeichnis BAD abgelegt.' }
      logerror(getres2(336,6));   { 'Fehlerhafter Netcallpuffer wurde im Unterverzeichnis BAD abgelegt.' }
      end
    else
      logerror(getres2(336,8)+puffer);   { 'Netcallpuffer wurde nicht eingelesen: ' }
    attrtxt(col.colmbox);
    writeln;
    mon;
    errsound;
    moff;
    write(getres(12));   { 'Taste drcken ...' }
    mon;
    errsound;
    cursor(curon);
    wkey(180,true);    { max. 3 Minuten }
    cursor(curoff);
    freeres;
    end;

  dispose(hdp);
  freemem(p,bufsize);
  window(1,1,80,25);
  closebox;
  aufbau:=true; xaufbau:=true;
end;


{ Datei fn ins Unterverzeichnis BAD\ verschieben; ggf. umbenennen }
{ Die Datei befindet sich normalerweise im XP- oder im SPOOL-     }
{ Verzeichnis.                                                    }

procedure MoveToBad(fn:pathstr);
var dest : pathstr;
    dir  : dirstr;
    name : namestr;
    ext  : extstr;
    f    : file;
begin
  fsplit(fn,dir,name,ext);
  if ustr(ext)='.OUT' then exit;   { UUCP: ausgehende Nachrichten }
  if ext='' then
    ext:='.001'
  else
    while exist(BadDir+name+ext) and (ext<>'.999') do
      ext:='.'+formi(ival(mid(ext,2))+1,3);
  if exist(BadDir+name+ext) then
    _era(BadDir+name+ext);
  if not exist(BadDir+name+ext) then begin
    assign(f,fn);
    {$I-}
    rename(f,BadDir+name+ext);
    if ioresult<>0 then;
    {$I+}
    end;
end;

