{ --------------------------------------------------------------- }
{ Dieses Programm ist urheberrechtlich geschuetzt.                }
{ (c) 1991-2001 Peter Mandrella                                   }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Sie duerfen dieses Programm unter den Bedingungen der GNU       }
{ General Public License ("GPL") Version 2 der Free Software      }
{ Foundation weitergeben und/oder veraendern.                     }
{                                                                 }
{ Die vollstaendigen Nutzungsbedingungen fuer dieses Programm     }
{ finden Sie in den beiliegenden Dateien SLIZENZ.TXT und COPYING  }
{ oder unter http://www.crosspoint.de/srclicense.html .           }
{ --------------------------------------------------------------- }

{ Overlay-Teil zu xp1 }

{$O+,B-,V-,F+}

unit xp1o;

interface

uses  crt,dos,dosx,typeform,keys,fileio,inout,maus2,lister,printerx,
      datadef,database,maske,archive,resource,clip,
      xp0,xpcrc32;

const ListKommentar : boolean = false;   { beenden mit links/rechts }
      ListQuoteMsg  : pathstr = '';
      ListXHighlight: boolean = true;    { fr F-Umschaltung }

var  listexit : shortint;   { 0=Esc/BS, -1=Minus, 1=Plus, 2=links, 3=rechts }
     listkey  : taste;


function  ReadFilename(txt:atext; var s:pathstr; subs:boolean;
                       var useclip:boolean):boolean;
function  overwrite(fname:pathstr; replace:boolean; var brk:boolean):boolean;
procedure listExt(var t:taste);
procedure ExtListKeys;
function  filecopy(fn1,fn2:pathstr):boolean;
function  FileDa(fn:pathstr):boolean;   { Programm im Pfad suchen }
procedure ExpandTabs(fn1,fn2:string);

function  GetDecomp(atyp:shortint; var decomp:string):boolean;
function  UniExtract(_from,_to,dateien:pathstr):boolean;
function  g_code(s:string):string;
procedure SeekLeftBox(var d:DB; var box:string);
procedure KorrBoxname(var box:string);
function  BoxFilename(var box:string):string;

procedure AddBezug(var hd:header; dateadd:byte);
procedure DelBezug;
function  GetBezug(var ref:string):longint;
function  KK:boolean;
function  HasRef:boolean;
function  ZCfiletime(var fn:pathstr):string;   { ZC-Dateidatum }
procedure SetZCftime(var fn:pathstr; var ddatum:string);

function  testtelefon(var s:string):boolean;
function  IsKomCode(nr:longint):boolean;
function  IsOrgCode(nr:longint):boolean;

procedure WinShell(prog:string; space:word; cls:shortint);


implementation

uses xp1,xp1o2,xp1input,xpkeys,xpnt,xp10;

var mo,bo,uo : boolean;
    mp,bp,up : longint;
    mi,bi,ui : shortint;



{ Dateinamen abfragen. Wenn Esc gedrckt wird, ist s undefiniert! }

function ReadFilename(txt:atext; var s:pathstr; subs:boolean;
                      var useclip:boolean):boolean;
var x,y : byte;
    brk : boolean;
    fn  : string[20];
begin
  fn:=getres(106);
  dialog(45+length(fn),3,txt,x,y);
  if not clipboard then useclip:=false;
  maddstring(3,2,fn,s,37,78,'');   { Dateiname: }
  if useclip then mappsel(false,'Windows-Clipboard');
  readmask(brk);
  enddialog;
  if not brk then begin
    UpString(s);
    if useclip and (s='WINDOWS-CLIPBOARD') then begin
      s:=TempS(65535);
      ClipToFile(s);
      end
    else
      useclip:=false;
    if (trim(s)='') or ((length(s)=2) and (s[2]=':')) or (right(s,1)='\') then
      s:=s+'*.*'
    else if IsPath(s) then
      s:=s+'\*.*';
    file_box(s,subs);
    if (s<>'') and (IsDevice(s) or not ValidFilename(s)) then begin
      rfehler(3);   { Ungltiger Pfad- oder Dateiname! }
      s:='';
      end;
    ReadFilename:=(s<>'');
    end
  else begin
    ReadFilename:=false;
    UseClip:=false;
    end;
end;


function overwrite(fname:pathstr; replace:boolean; var brk:boolean):boolean;
var x,y : byte;
    nr  : shortint;
    t   : taste;
    f   : file;
    w   : word;
begin
  assign(f,fname);
  getfattr(f,w);
  if w and readonly<>0 then begin
    rfehler(9);        { 'Datei ist schreibgeschtzt.' }
    brk:=true;
    exit;
    end;
  diabox(57,5,'',x,y);
  mwrt(x+2,y+1,ustr(fitpath(fname,28))+getres(117));  { ' ist bereits vorhanden.' }
  t:='';
  pushhp(76);
  nr:=readbutton(x+2,y+3,2,getres(118),iif(replace,2,1),true,t);  { ' ^Anhngen , ^berschreiben , A^bbruch ' }
  pophp;
  closebox;
  overwrite:=(nr=2);
  if nr=2 then begin    { Datei lschen -> evtl. Undelete mglich }
    {$I-}
    setfattr(f,0);
    erase(f);
    if ioresult<>0 then;
    {$I+}
    end;
  brk:=(nr=0) or (nr=3);
end;

procedure listExt(var t:taste);
var s     : string;
    all   : boolean;
    b     : byte;
    ok    : boolean;
    fname : pathstr;
    append: boolean;
    tt    : text;
    brk   : boolean;
    c     : char;
    useclip: boolean;
    nr    : longint;
    i     : integer;

  procedure ex(i:shortint);
  begin
    listexit:=i;
    t:=keyesc;
  end;

begin
  if listmakros<>0 then begin
    if t=keyf6 then Makroliste(iif(listmakros=8,4,5));
    Xmakro(t,ListMakros);
    end;
  c:=t[1];
  if (UpCase(c)=k4_D) or (deutsch and (UpCase(c)='D')) then begin   { ^D }
    rmessage(119);   { 'Ausdruck luft...' }
    InitPrinter;
    all:=(list_markanz=0);
    if all then s:=first_line
    else s:=first_marked;
    while checklst and (s<>#0) do begin
      PrintLine(s);
      if all then s:=next_line
      else s:=next_marked;
      end;
    ExitPrinter;
    closebox;
    end;

  if UpCase(c)=k4_W then begin                           { 'W' }
    fname:='';
    pushhp(74);
    useclip:=true;
    ok:=ReadFileName(getres(120),fname,true,useclip);  { 'Text in Datei schreiben' }
    pophp;
    if ok then begin
      if (pos('\',fname)=0) and (pos(':',fname)=0) then
        fname:=extractpath+fname;
      while cpos('/',fname)>0 do
        fname[cpos('/',fname)]:='\';
      if not validfilename(fname) then begin
        rfehler(316);   { 'Ungltiger Pfad- oder Dateiname!' }
        exit;
        end;
      if exist(fname) and not useclip then
        append:=not Overwrite(fname,false,brk)
      else begin
        append:=false; brk:=false;
        end;
      if not brk then begin
        assign(tt,fname);
        if append then system.append(tt)
        else rewrite(tt);
        all:=(list_markanz=0);
        if all then s:=first_line
        else s:=first_marked;
        while s<>#0 do begin
          writeln(tt,s);
          if all then s:=next_line
          else s:=next_marked;
          end;
        close(tt);
        if useclip then WriteClipfile(fname);
        end
      else
        if useclip then _era(fname);
      end;
    end;

  if UpCase(c)=k4_F then                                 { 'F' }
    ListXHighlight:=not ListXHighlight;

  if listmakros=16 then   { Archiv-Viewer }
    if t=mausldouble then
      t:=keycr;
  if llh then begin
    if (t=keydel) or (ustr(t)=k4_L) or (t=k4_cL) then begin   { 'L' / ^L }
      b:=2;
      dbWriteN(mbase,mb_halteflags,b);
      if t=k4_cL then begin
        rmessage(121);   { 'Nachricht ist auf ''lschen'' gesetzt.' }
        wkey(1,false);
        closebox;
        end
      else
        t:=keyesc;
      end else
    if (t=keyins) or (ustr(t)=k4_H) then begin         { 'H' }
      b:=1;
      dbWriteN(mbase,mb_halteflags,b);
      rmessage(122);   { 'Nachricht ist auf ''halten'' gesetzt.' }
      wkey(1,false);
      closebox;
      end else
    if (t=keybs) then begin
      NachWeiter:=false;
      t:=keyesc;
      end else
    if c=^K then kludges:=not kludges else
    if c='-' then ex(-1) else
    if c='+' then ex(1) else
    if (c=k2_p) or (c=k2_b) or
       ((listmakros<>16) and ((c=k2_cB) or (c=k2_cP) or (c=k2_cQ))) then
    begin
      ListKey:=t;
      if ((c=k2_cB) or (c=k2_cQ) or (c=k2_cP)) and (list_markanz>0) then begin
        ListQuoteMsg:=TempS(dbReadInt(mbase,'msgsize'));
        assign(tt,ListQuoteMsg);
        rewrite(tt);
        if ntZConnect(mbNetztyp) then begin
          writeln(tt,'Dummy:');
          writeln(tt);
          end
        else
          for i:=1 to 8 do writeln(tt);
        s:=first_marked;
        nr:=current_linenr;
        while s<>#0 do begin
          writeln(tt,s);
          s:=next_marked;
          if current_linenr>nr+1 then writeln(tt,#3);
          nr:=current_linenr;
          end;
        close(tt);
        end;
      ex(4);
      end else
    if listkommentar then
      if t=keyleft then ex(2) else
      if t=keyrght then ex(3) else
      if t=keycpgu then ex(6) else
      if t=keycpgd then ex(7) else
      if t='0' then ex(5);
    end;
end;

procedure ExtListKeys;
begin
  case errorlevel of
    100 : listexit:=-1;   { - }
    101 : listexit:=1;    { + }
    102 : listexit:=2;    { links }
    103 : listexit:=3;    { rechts }
    104 : begin
            listexit:=4; listkey:=k2_b;
          end;
    105 : begin
            listexit:=4; listkey:=k2_p;
          end;
    106 : begin
            listexit:=4; listkey:=k2_cB;
          end;
    107 : begin
            listexit:=4; listkey:=k2_cP;
          end;
    108 : listexit:=5;    { 0 }
    109 : listexit:=6;    { PgUp }
    110 : listexit:=7;    { PgDn }
  end;
end;



function filecopy(fn1,fn2:pathstr):boolean;
var f1,f2 : file;
    time  : longint;
    res   : integer;
begin
  if (fexpand(fn1)=fexpand(fn2)) and exist(fn1) then begin
    filecopy:=true;
    exit;
    end;
  {$I-}
  assign(f1,fn1);
  reset(f1,1);
  getftime(f1,time);
  assign(f2,fn2);
  rewrite(f2,1);
    fmove(f1,f2);
  setftime(f2,time);
  close(f1); close(f2);
  filecopy:=(inoutres=0);
  if inoutres<>0 then begin
    res:=ioresult;
    tfehler(ioerror(res,
       reps(getreps(123,strs(res)),fileio.getfilename(fn1))),30);
                                 { 'Fehler %s beim Kopieren von %s' }
    end;
  {$I+}
end;


function GetDecomp(atyp:shortint; var decomp:string):boolean;
begin
  with unpacker^ do
    case atyp of
      1 : decomp:=UnARC;
      2 : decomp:=UnLZH;
      3 : decomp:=UnZOO;
      4 : decomp:=UnZIP;
      5 : decomp:=UnARJ;
      6 : decomp:=UnPAK;
      7 : decomp:=UnDWC;
      8 : decomp:=UnHYP;
      9 : decomp:=UnSQZ;
     10 : decomp:='tar -xvf $ARCHIV $DATEI';
     11 : decomp:=UnRAR;
     12 : decomp:='uc e $ARCHIV $DATEI';
    else begin  { ?? }
      getDecomp:=false;
      decomp:=''; exit;
      end;
    end;
  if (pos('$DATEI',ustr(decomp))=0) or (pos('$ARCHIV',ustr(decomp))=0) then begin
    rfehler1(8,arcname[atyp]);   { 'Die Einstellung des %s-Entpacker ist fehlerhaft' }
    getDecomp:=false;
    end
  else
    getdecomp:=true;
end;


function UniExtract(_from,_to,dateien:pathstr):boolean;
var decomp : pathstr;
    atyp   : shortint;
    p      : byte;
begin
  UniExtract:=false;
  atyp:=ArcType(_from);
  if atyp=0 then exit;
  GoDir(_to);
  if not GetDecomp(atyp,decomp) then exit;
  p:=pos('$ARCHIV',ustr(decomp));
  decomp:=left(decomp,p-1)+_from+mid(decomp,p+7);
  p:=pos('$DATEI',ustr(decomp));
  shell(left(decomp,p-1)+dateien+mid(decomp,p+6),400,3);
  if not exist(_to+dateien) then
    tfehler('Datei(en) wurde(n) nicht korrekt entpackt!',30)
  else
    UniExtract:=true;
end;


procedure AddBezug(var hd:header; dateadd:byte);
var c1,c2 : longint;
    satz  : longint;
    datum : longint;
    empfnr: byte;
begin
  if ntKomkette(hd.netztyp) and (hd.msgid<>'') then begin
    c1:=MsgidIndex(hd.msgid);
    if hd.ref='' then c2:=0
    else c2:=MsgidIndex(hd.ref);
    dbAppend(bezbase);           { s. auch XP3O.Bezugsverkettung }
    satz:=dbRecno(mbase);
    dbWriteN(bezbase,bezb_msgpos,satz);
    dbWriteN(bezbase,bezb_msgid,c1);
    dbWriteN(bezbase,bezb_ref,c2);
    dbReadN(mbase,mb_origdatum,datum);
    datum:=datum and $fffffff0;  { Bit 0-3 lschen }
    if dateadd>0 then
      inc(datum,dateadd)
    else begin
      empfnr:=dbReadInt(mbase,'netztyp') shr 24;
      if empfnr>0 then
        inc(datum,iif(empfnr=1,1,2));
      end;
    dbWriteN(bezbase,bezb_datum,datum);
    end;
end;


function KK:boolean;
begin
  KK:=ntKomkette(dbReadInt(mbase,'netztyp')and $ff) and
     (dbReadStr(mbase,'msgid')<>'');
end;

function HasRef:boolean;
begin
  dbSeek(bezbase,beiRef,left(dbReadStr(mbase,'msgid'),4));
  HasRef:=dbFound;
end;

procedure DelBezug;
var crc : string[4];
    pos : longint;
    mi  : shortint;
    ok  : boolean;
    nr  : byte;
    dat : longint;

  function MidOK:boolean;
  begin
    MidOK:=(dbLongStr(dbReadInt(bezbase,'msgid'))=crc);
  end;

  function DatOK:boolean;
  begin
    DatOK:=(dbReadInt(bezbase,'datum') and $fffffff0)=dat;
  end;

begin
  if KK then begin
    pos:=dbRecno(mbase);
    crc:=left(dbReadStr(mbase,'msgid'),4);
    mi:=dbGetIndex(bezbase); dbSetIndex(bezbase,beiMsgid);
    dbSeek(bezbase,beiMsgid,crc);
    ok:=dbfound;
    while ok and (dbReadInt(bezbase,'msgpos')<>pos) do begin
      dbNext(bezbase);
      ok:=not dbEOF(bezbase) and MidOK;
      end;
    if ok then begin
      nr:=dbReadInt(bezbase,'datum') and 3;
      dat:=dbReadInt(bezbase,'datum') and $fffffff0;
      dbDelete(bezbase);
      if nr=1 then begin        { erste Kopie eines CrossPostings }
        dbSeek(bezbase,beiMsgid,crc);
        if dbFound then begin
          while not dbEOF(bezbase) and not DatOK and MidOK do
            dbNext(bezbase);
          if not dbEOF(bezbase) and DatOK and MidOK and
             (dbReadInt(bezbase,'datum') and 3=2) then begin
            inc(dat);        { + 1 }
            dbWrite(bezbase,'datum',dat);
            end;
          end;
        end;
      end
    else if developer then begin
      sound(4000); delay(5); nosound;
      end;
    dbSetIndex(bezbase,mi);
    end;
end;


function GetBezug(var ref:string):longint;
var pos : longint;
begin
  dbSeek(bezbase,beiMsgid,dbLongStr(MsgidIndex(ref)));
  if dbFound then begin
    pos:=dbReadInt(bezbase,'msgpos');
    dbGo(mbase,pos);
    if dbDeleted(mbase,pos) then
      GetBezug:=0
    else
      GetBezug:=pos;
    end
  else
    GetBezug:=0;
end;


function g_code(s:string):string;
var i : byte;
begin
  for i:=1 to length(s) do
    s[i]:=chr(byte(s[i]) xor (i mod 7));
  g_code:=s;
end;


procedure SeekLeftBox(var d:DB; var box:string);
begin
  if ((length(box)<=2) and (left(box,1)=left(DefFidoBox,1))) then
    box:=DefFidoBox;
  dbSeek(d,boiName,ustr(box));
  if not dbFound and (box<>'') and not dbEOF(d) and
     (ustr(left(dbReadStr(d,'boxname'),length(box)))=ustr(box)) then begin
    dbRead(d,'boxname',box);
    dbSeek(d,boiName,ustr(box));
    end;
end;


function FileDa(fn:pathstr):boolean;   { Programm im Pfad suchen }
var dir  : dirstr;
    name : namestr;
    ext  : extstr;
  function Find(fn:pathstr):boolean;
  begin
    Find:=Fsearch(fn,GetEnv('PATH'))<>'';
  end;
begin
  if cpos(' ',fn)>0 then
    fn:=left(fn,cpos(' ',fn)-1);
  fsplit(fn,dir,name,ext);
  if ustr(name+ext)='COPY' then
    fileda:=true
  else
    if ext<>'' then
      FileDa:=Find(fn)
    else
      FileDa:=Find(fn+'.exe') or Find(fn+'.com') or Find(fn+'.bat');
end;


function ZCfiletime(var fn:pathstr):string;   { ZC-Dateidatum      }
var l  : longint;
    dt : datetime;
    f  : file;
begin
  assign(f,fn);
  {$I-}
  reset(f,1);
  {$I+}
  if ioresult<>0 then
    ZCfiletime:=''
  else begin
    getftime(f,l);
    close(f);
    unpacktime(l,dt);
    with dt do
      ZCfiletime:=formi(year,4)+formi(month,2)+formi(day,2)+
                  formi(hour,2)+formi(min,2)+formi(sec,2);
    end;
end;


procedure SetZCftime(var fn:pathstr; var ddatum:string);
var dt : datetime;
    l  : longint;
    f  : file;
begin
  assign(f,fn);
  {$I-}
  reset(f,1);
  {$I+}
  if ioresult=0 then with dt do begin
    year:=ival(left(ddatum,4));
    month:=ival(copy(ddatum,5,2));
    day:=ival(copy(ddatum,7,2));
    hour:=ival(copy(ddatum,9,2));
    min:=ival(copy(ddatum,11,2));
    sec:=ival(copy(ddatum,13,2));
    packtime(dt,l);
    setftime(f,l);
    close(f);
    end;
end;


procedure KorrBoxname(var box:string);
var d : DB;
begin
  dbOpen(d,BoxenFile,1);
  dbSeek(d,boiName,ustr(box));
  if dbFound or
     (not dbEOF(d) and (ustr(left(dbReadStr(d,'boxname'),length(box)))=ustr(box)))
  then
    dbRead(d,'boxname',box);  { -> korrekte Schreibweise des Systemnamens }
  dbClose(d);
end;


function BoxFilename(var box:string):string;
var d : DB;
begin
  dbOpen(d,BoxenFile,1);
  dbSeek(d,boiName,ustr(box));
  if dbFound then BoxFilename:=dbReadStr(d,'dateiname')
  else BoxFilename:=ustr(box);
  dbClose(d);
end;


function testtelefon(var s:string):boolean;
var tele,tnr : string[TeleLen+1];
    p,n      : byte;
    ok       : boolean;
    endc     : set of char;
    errmsg   : boolean;
begin
  errmsg:=(firstchar(s)<>'');
  if not errmsg then delfirst(s);
  repeat
    p:=pos('+49-0',s);
    if p>0 then delete(s,p+4,1);   { 0 aus +49-0 wegschneiden }
  until p=0;
  ok:=true;
  n:=0;
  if s<>'' then begin
    tele:=trim(s)+' ';
    repeat
      inc(n);
      p:=blankpos(tele);
      tnr:=left(tele,p-1);
      tele:=ltrim(mid(tele,p));
      endc:=['0'..'9'];
      if pos('V',tnr)>0 then include(endc,'Q');
      while firstchar(tnr) in ['V','F','B','P'] do
        delfirst(tnr);
      if (firstchar(tnr)<>'+') or not (lastchar(tnr) in endc) then
        ok:=false;
      if pos('+',mid(tnr,2))>0 then
        ok:=false;
    until tele='';
    if not ok and errmsg then
      rfehler(iif(n=1,211,212));  { 'Telefonnummer(n) hat/haben falsches Format - s. Online-Hilfe!' }
    end;
  testtelefon:=ok;
end;


function IsKomCode(nr:longint):boolean;
begin
  if (nr>=4000) and (nr<=4199) then
    IsKomCode:=(nr-4000 in [10..14,26..30,32..48,50,51,53..66,68..83,87,
                            89,93..115,122..124,126..131,134,137..139,
                            153..162,164..191,193..199])
  else if (nr>=4200) and (nr<=4399) then
    IsKomCode:=(nr-4200 in [0,44..60,63,64,68,70,71,82..120,122..131,135,
                            136])
  else
    IsKomCode := (nr>14000) and (nr<15000);
end;


function IsOrgCode(nr:longint):boolean;
begin
  if (nr>=4000) and (nr<=4199) then
    IsOrgCode:=(nr-4000 in [15..25,31,49,52,67,84..86,88,90..92,116..121,
                            125,132,133,135,136,140..152,163,192])
  else if (nr>=4200) and (nr<=4399) then
    IsOrgCode:=(nr-4200 in [1..43,61,62,65,67,69,72..81,121,132,134])
  else
    IsOrgCode := (nr>13000) and (nr<14000);
end;


procedure ExpandTabs(fn1,fn2:string);
var t1,t2 : text;
    s     : string;
    buf   : array[1..1024] of byte;
    p     : byte;
begin
  assign(t1,fn1);
  settextbuf(t1,buf);
  if existf(t1) then begin
    reset(t1);
    assign(t2,fn2);
    rewrite(t2);
    while not eof(t1) do begin
      readln(t1,s);
      while (s[length(s)]=' ') do dec(byte(s[0]));  { Spaces wegschneiden }
      repeat
        p:=pos(#9,s);              { TABs expandieren }
        if p>0 then begin
          delete(s,p,1);
          insert(sp(8-(p-1)mod 8),s,p);
          end;
      until p=0;
      writeln(t2,s);
      end;
    close(t2);
    close(t1);
    end;
end;


{ externer Programmaufruf (vgl. xp1s.shell())               }
{                                                           }
{ Bei Windows-Programmen wird WINRUN.BAT erzeugt/gestartet. }
{ Bei OS/2-Programmen wird OS2RUN.BAT erzeugt/gestartet.    }

procedure WinShell(prog:string; space:word; cls:shortint);

  procedure PrepareExe;    { Stack sparen }
  var ext     : string[3];
      exepath : pathstr;
      et      : TExeType;
      win,os2 : boolean;
      t       : text;
  begin
    exepath:=left(prog,blankposx(prog)-1);
    ext:=GetFileExt(exepath);
    if ext='' then exepath:=exepath+'.exe';
    exepath:=fsearch(exepath,getenv('PATH'));
    if not stricmp(right(exepath,4),'.exe') then
      et:=ET_Unknown
    else
      et:=exetype(exepath);

    win := (et=ET_Win16) or (et=ET_Win32);
    os2 := (et=ET_OS2_16) or (et=ET_OS2_32);

    if win then begin
      if not exist('winrun.bat') then begin
        assign(t,'winrun.bat');
        rewrite(t);
        writeln(t,'@echo off');
        writeln(t,'rem  Diese Datei wird von CrossPoint zum Starten von Windows-Viewern');
        writeln(t,'rem  aufgerufen (siehe Online-Hilfe zu /Edit/Viewer).');
        writeln(t);
        writeln(t,'echo Windows-Programm wird ausgefhrt ...');
        writeln(t,'echo.');
        writeln(t,'cmd /c "start /wait %1 %2 %3 %4 %5 %6"');
        writeln(t,'echo.');
        close(t);
        end;
      prog:='winrun.bat '+prog;
      end
    else if os2 then begin
      if not exist('os2run.bat') then begin
        assign(t,'os2run.bat');
        rewrite(t);
        writeln(t,'@echo off');
        writeln(t,'rem  Diese Datei wird von CrossPoint zum Starten von OS/2-Viewern');
        writeln(t,'rem  aufgerufen (siehe Online-Hilfe zu /Edit/Viewer).');
        writeln(t);
        writeln(t,'echo OS/2-Programm wird ausgefhrt ...');
        writeln(t,'echo.');
        writeln(t,'%1 %2 %3 %4 %5 %6');
        writeln(t,'echo.');
        close(t);
        end;
      prog:='os2run.bat '+prog;
      end;
  end;

begin
  PrepareExe;
  shell(prog,space,cls);
end;


end.
