{ --------------------------------------------------------------- }
{ Dieses Programm ist urheberrechtlich geschuetzt.                }
{ (c) 1991-2001 Peter Mandrella                                   }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Sie duerfen dieses Programm unter den Bedingungen der GNU       }
{ General Public License ("GPL") Version 2 der Free Software      }
{ Foundation weitergeben und/oder veraendern.                     }
{                                                                 }
{ Die vollstaendigen Nutzungsbedingungen fuer dieses Programm     }
{ finden Sie in den beiliegenden Dateien SLIZENZ.TXT und COPYING  }
{ oder unter http://www.crosspoint.de/srclicense.html .           }
{ --------------------------------------------------------------- }

{ CrossPoint-Meneditor }

uses  crt,typeform,fileio,keys,maus2,inout,resource,video,windows,
      xdelay;

const menus      = 99;
      maxhidden  = 500;
      menufile   = 'xpmenu.dat';
      meversion  = 1;     { Versionsnummer Mendatenformat }

      menupos : array[0..menus] of byte = (1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                                           1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                                           1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                                           1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                                           1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                                           1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
      modi  : boolean = false;
      ropen : boolean = false;
      saved : boolean = false;
      hcursor : boolean = false;   { Blindencursor }

{$I xpmecol.inc}   { Farben }


type  mprec     = record
                    mstr    : string[30];
                    hpos    : byte;
                    hkey    : char;
                    enabled : boolean;
                    chain   : byte;      { Untermen-Nr. }
                    keep    : boolean;   { Men nicht verlassen }
                    mpnr    : integer;   { Nummer des Menpunkts }
                  end;
      menuarray = array[1..22] of mprec;
      map       = ^menuarray;
const mainmenu  : map = nil;

var   menu      : array[0..menus] of ^string;
      menulevel : byte;
      main_n    : integer;
      menustack : array[0..4] of byte;   { fr Rekonstruktion im Config-Men }
      hmpos     : array[1..10] of byte;  { Hauptmen-XPos }
      hidden    : array[1..maxhidden] of integer;
      anzhidden : integer;
      specials  : string;
      mback     : boolean;


procedure wrlogo;
begin
  writeln;
  writeln('CrossPoint-Meneditor v1.02   (c) ''96-99 Peter Mandrella, Freeware');
  writeln;
end;


procedure error(txt:string);
begin
  wrlogo;
  writeln('Fehler: ',txt,#7);
  if ropen then CloseResource;
  halt;
end;


procedure readmenus;
var t  : text;
    s  : string;
    i  : integer;
begin
  if not exist('xp.res') and not exist('xp-d.res') then begin
    wrlogo;
    writeln('Fehler: XP-D.RES nicht gefunden.'#7);
    writeln;
    writeln('Starten Sie dieses Programm bitte in einem Verzeichnis, in dem');
    writeln('CrossPoint vollstndig installiert wurde.');
    writeln;
    halt;
    end;
  assign(t,'xp.res');
  if existf(t) then begin
    reset(t);
    readln(t,s);
    close(t);
    end
  else
    s:='xp-d.res';
  if not exist(s) then
    error(s+' fehlt!');
  OpenResource(s,10000);
  ropen:=true;
  if ival(getres(6))<11 then
    error('Es wird CrossPoint Version 3.11 oder hher bentigt!');
  for i:=0 to menus do begin
    s:=getres2(10,i);   { "[fehlt:...]" kann hier ignoriert werden. }
    getmem(menu[i],length(s)+1);
    menu[i]^:=s;
    end;
  specials:=getres2(10,200);
  CloseResource;
end;


procedure Readconfig;
var t : text;
    s : string;
    p : byte;
begin
  assign(t,'xpoint.cfg');
  if existf(t) then begin
    reset(t);
    repeat
      readln(t,s);
      p:=cpos('=',s);
      if (s[1]<>'#') and (p>0) then
        if lstr(left(s,p-1))='auswahlcursor' then
          hcursor:=(ustr(mid(s,p+1))='J');
    until eof(t);
    close(t);
    end;
end;


procedure showscreen;
var i : integer;
begin
  shadowcol:=0;
  cursor(curoff);
  attrtxt(7);
  clrscr;
  inc(windmax,$100);
  mback:=getbackintensity;
  setbackintensity(true);
  attrtxt(col.colmenu[0]);
  write(sp(80));
  attrtxt(col.colback);
  for i:=1 to 24 do
    write(dup(80,''));
  attrtxt(col.colutility);
  forcecolor:=true;
  rahmen1(38,78,18,23,'');
  wshadow(39,79,19,24);
  wrt(40,18,' CrossPoint-Meneditor ');
  clwin(39,77,19,22);
  forcecolor:=false;
  attrtxt(col.colutihigh);
  wrt(42,20,#27#24#25#26);
  wrt(42,21,'+ -');
  wrt(42,22,'Esc');
  attrtxt(col.colutility);
  wrt(50,20,'Men(punkt) whlen');
  wrt(50,21,'Men(punkt) (de)aktivieren');
  wrt(50,22,'Ende');
end;


procedure msgbox(wdt,hgh:byte; txt:string; var x,y:byte);
begin
  x:=(80-wdt)div 2;
  y:=(25-hgh)div 2;
  attrtxt(col.colmbox);
  forcecolor:=true;
  wpushs(x,x+wdt,y,y+hgh,'');
  forcecolor:=false;
  if txt<>'' then wrt(x+2,y,' '+txt+' ');
end;


procedure closebox;
begin
  wpop;
end;


procedure errsound;
begin
  sound(1000);
  delay(25);
  sound(780);
  delay(25);
  nosound;
end;


{ --- Mensystem -------------------------------------------------------- }

function special(nr:integer):boolean;
var x,y : byte;
    t   : taste;
begin
  if pos('$'+hex(nr,3),ustr(specials))>0 then begin
    msgbox(60,6,'',x,y);
    wrt(x+3,y+2,'Dieser Menpunkt wird von XP automatisch aktiviert bzw.');
    wrt(x+3,y+3,'deaktiviert (s. XPME.DOC).');
    wrt(x+3,y+5,'Taste drcken ...');
    errsound;
    get(t,curon);
    closebox;
    special:=true;
    end
  else
    special:=false;
end;


procedure click;
begin
  sound(4000);
  delay(10);
  nosound;
end;


procedure addhidden(nr:integer);
var i : integer;
begin
  if anzhidden<maxhidden then begin
    i:=anzhidden+1;
    while (i>1) and (hidden[i-1]>=nr) do
      dec(i);
    if (i>anzhidden) or (hidden[i]<>nr) then begin
      if i<=anzhidden then
        move(hidden[i],hidden[i+1],(anzhidden+1-i)*sizeof(hidden[1]));
      hidden[i]:=nr;
      inc(anzhidden);
      click;
      end;
   end;
end;


procedure delhidden(nr:integer);
var i : integer;
begin
  i:=1;
  while (i<=anzhidden) and (hidden[i]<>nr) do
    inc(i);
  if i<=anzhidden then begin
    if (i<anzhidden) then
      move(hidden[i+1],hidden[i],(anzhidden-i)*sizeof(hidden[1]));
    dec(anzhidden);
    click;
    end;
end;


function ishidden(nr:integer):boolean;
var l,r,m : integer;
begin
  l:=1; r:=anzhidden;
  while (r-l>1) do begin
    m:=(l+r) div 2;
    if hidden[m]<nr then l:=m
    else r:=m;
    end;
  ishidden:=(r>0) and ((nr=hidden[l]) or (nr=hidden[r]));
end;


procedure splitmenu(nr:byte; ma:map; var n:integer);
var s       : string;
    p,p2,p3 : byte;
begin
  s:=menu[nr]^;
  n:=0;
  repeat
    p:=pos(',',s);
    if p>0 then begin
      inc(n);
      with ma^[n] do begin
        s:=copy(s,p+1,255);
        if left(s,2)<>'-,' then begin
          mpnr:=hexval(left(s,3));
          delete(s,1,3);
          end
        else
          mpnr:=0;
        enabled:=not ishidden(mpnr);
        if s[1]='!' then begin      { Men nicht verlassen? }
          keep:=true;
          delete(s,1,1);
          end
        else
          keep:=false;
        p2:=pos('^',s);
        p3:=pos(',',s);
        if (p3=0) or ((p2>0) and (p2<p3)) then begin
          if p2>0 then delete(s,p2,1);
          if p3>0 then dec(p3);
          hpos:=p2;
          end
        else
          hpos:=0;
        p2:=p3;
        if p2=0 then mstr:=s
        else mstr:=left(s,p2-1);
        if hpos>0 then hkey:=UpCase(mstr[hpos])
        else hkey:=#255;
        if pos('',mstr)>0 then begin
          p2:=pos('',mstr);
          chain:=ival(copy(mstr,p2+1,40));
          mstr:=copy(mstr,1,p2-1);
          if (nr>0) and (pos('..',mstr)=0) then mstr:=mstr+'..';
          end
        else chain:=0;
        end;
      end;
  until p=0;
end;


procedure showmain(nr:shortint);
var i      : integer;
    xp,xp2 : byte;
    s      : string[20];
    p      : byte;
begin
  if mainmenu=nil then begin
    new(mainmenu);
    splitmenu(0,mainmenu,main_n);
    end;
  gotoxy(2,1);
  for i:=1 to main_n do
    with mainmenu^[i] do begin
      hmpos[i]:=wherex+1;
      if enabled then begin
        if nr=i then attrtxt(col.colmenuinv[0])
        else attrtxt(col.colmenu[0]);
        s:=mstr;
        write(' ');
        if hpos>1 then
          write(left(s,hpos-1));
        if i=nr then attrtxt(col.colmenuinvhi[0])
        else attrtxt(col.colmenuhigh[0]);
        write(s[hpos]);
        if i=nr then attrtxt(col.colmenuinv[0])
        else attrtxt(col.colmenu[0]);
        write(copy(s,hpos+1,20),' ');
        end
      else begin
        if nr=i then attrtxt(col.colmenuseldis[0])
        else attrtxt(col.colmenudis[0]);
        write(' ',mstr,' ');
        end;
      end;
end;


{ nr       : Mennummer                                    }
{ enterkey : erster Tastendruck                            }
{ x,y      : Koordinaten fr Untermen-Anzeige             }
{ Return   : xxy (Hex!) : Punkt y in Men xx wurde gewhlt }
{             0: Men mit Esc oder sonstwie abgebrochen    }
{            -1: Untermen nach links verlassen            }
{            -2: Untermen nach rechts verlassen           }

function getmenu(nr:byte; enterkey:taste; x,y:byte):integer;
const EnableUpper : boolean = true;
var ma    : map;
    n,i   : integer;
    t     : taste;
    p,ml  : byte;
    pold  : byte;
    get2  : integer;
    xx,yy : byte;
    autolr: byte;
    dead  : boolean;   { alle disabled }
    has_checker : boolean;
    mausback : boolean;

  procedure display;
  var i,hp  : byte;
      s     : string[40];
      check : char;
  begin
    if nr=0 then showmain(p)
    else begin
      for i:=1 to n do begin
        s:=ma^[i].mstr;
        hp:=ma^[i].hpos;
        if (i<>p) or dead then
          if ma^[i].enabled then attrtxt(col.colmenu[menulevel])
          else attrtxt(col.colmenudis[menulevel])
        else
          if ma^[i].enabled then attrtxt(col.colmenuinv[menulevel])
          else attrtxt(col.colmenuseldis[menulevel]);
        check:=' ';
        if s='-' then
          wrt(x,y+i,''+dup(ml,'')+'')
        else if hp=0 then
          wrt(x+1,y+i,check+forms(s,ml-1))
        else if not ma^[i].enabled then
          wrt(x+1,y+i,' '+forms(s,ml-1))
        else begin
          wrt(x+1,y+i,check+left(s,hp-1));
          if i<>p then attrtxt(col.colmenuhigh[menulevel])
          else attrtxt(col.colmenuinvhi[menulevel]);
          write(s[hp]);
          if i<>p then attrtxt(col.colmenu[menulevel])
          else attrtxt(col.colmenuinv[menulevel]);
          write(forms(copy(s,hp+1,40),ml-hp-1));
          end;
        end;
      end;
  end;

  function nomp(p:byte):boolean;
  begin
    nomp:=(ma^[p].mstr='-'){ or ((nr=0) and not ma^[p].enabled)};
  end;

  procedure DoEnable;
  begin
    if not special(ma^[p].mpnr) and ishidden(ma^[p].mpnr) then begin
      if nr=0 then mainmenu^[p].enabled:=true;
      ma^[p].enabled:=true;
      DelHidden(ma^[p].mpnr);
      display;
      modi:=true;
      end;
  end;

  procedure DoDisable;
  begin
    if not special(ma^[p].mpnr) and not ishidden(ma^[p].mpnr) then begin
      if nr=0 then mainmenu^[p].enabled:=false;
      ma^[p].enabled:=false;
      AddHidden(ma^[p].mpnr);
      display;
      modi:=true;
      end;
  end;

begin
  if nr=0 then menulevel:=0;
  new(ma);
  splitmenu(nr,ma,n);
  has_checker:=false;
  p:=min(menupos[nr],n);
  i:=1;
  while nomp(p) and (i<=n) do begin
    p:=p mod n + 1; inc(i);
    end;
  dead:=i>n;
  autolr:=0;
  if nr>0 then begin
    ml:=0;
    for i:=1 to n do
      ml:=max(ml,length(ma^[i].mstr));
    inc(ml,2);
    x:=min(x,78-ml);
    attrtxt(col.colmenu[menulevel]);
    forcecolor:=true;
    wpushs(x,x+ml+1,y,y+n+1,'');
    forcecolor:=false;
    end
  else
    if (nr=0) and (enterkey<>keyf10) then begin
      i:=1;
      while (i<=n) and (ma^[i].hkey<>UStr(enterkey)) do inc(i);
      if i<=n then begin
        p:=i;
        autolr:=1;
        end;
      end;

  mausback:=false;
  pold:=99;
  repeat
    if p<>pold then display;
    pold:=p;
    case autolr of
      4 : begin {t:=mausleft;} autolr:=0; end;
      3 : begin t:=keyrght; autolr:=1; end;
      2 : begin t:=keyleft; autolr:=1; end;
      1 : begin t:=keycr; autolr:=0; end;
    else
      if hcursor then begin
        if nr=0 then gotoxy(hmpos[p]-1,1)
        else gotoxy(x+1,y+p);
        get(t,curon);
        end
      else
        get(t,curoff);
    end;
    if not dead then begin
      i:=1;
      while (i<=n) and (ma^[i].hkey<>UStr(t)) do inc(i);
      if (i<=n) and (ma^[i].enabled) then begin
        p:=i; t:=keycr;
        display;
        end
      else begin
        if t=keyhome then begin
          p:=1;
          if nomp(p)  then t:=keytab;
          end;
        if t=keyend then begin
          p:=n;
          if nomp(p) then t:=keystab;
          end;
        if ((nr=0) and (t=keyrght)) or ((nr>0) and (t=keydown)) or
           (t=keytab) or (not has_checker and (t=' ')) then
            repeat
              p:=(p mod n)+1
            until not nomp(p);
        if ((nr=0) and (t=keyleft)) or
           ((nr>0) and (t=keyup)) or (t=keystab) then
             repeat
               if p=1 then p:=n else dec(p)
             until not nomp(p);
        end;

      if nr=0 then begin
        if t=keyf10 then t:=keyesc;
        if t=keydown then t:=keycr;
        end;

      if t='+' then DoEnable;
      if t='-' then DoDisable;

      get2:=0;
      if t=keycr then
        if ma^[p].enabled then
          if ma^[p].chain>0 then begin
            if nr=0 then begin
              xx:=hmpos[p]-1; yy:=2; end
            else begin
              xx:=x+2; yy:=y+1+p; end;
            menupos[nr]:=p;
            menustack[menulevel]:=p;
            inc(menulevel);
            get2:=getmenu(ma^[p].chain,'',xx,yy);
            dec(menulevel);
            if EnableUpper then DoEnable
            else DoDisable;
            case get2 of
              0  : {if nr>0 then} t:='';
             -1  : if nr>0 then t:=keyleft
                   else begin
                     autolr:=2; t:=''; end;
             -2  : if nr>0 then t:=keyrght
                   else begin
                     autolr:=3; t:=''; end;
             -3  : begin autolr:=4; t:=''; end;
            end  { case }
          end
        else begin   { kein Untermen }
          { get2:=ma^[p].mpnr;
            menustack[menulevel]:=p; }
          t:='';
          end
      else  { not enabled }
        t:='';

      if (ma^[p].keep) and (get2>0) then
        t:='';

      end;   { not dead }

  until (t=keyesc) or ((nr>0) and ((t=keyleft) or (t=keyrght)));

  if nr>0 then wpop
  else showmain(0);
  menupos[nr]:=p;
  dispose(ma);

  if nr>0 then begin
    i:=1;
    while (i<=n) and (not ma^[i].enabled or (ma^[i].mstr='-')) do
      inc(i);
    EnableUpper:=(i<=n);
    end;

  if t=keyesc then getmenu:=0
  else if t=keycr then getmenu:=get2
  else if t=keyleft then getmenu:=-1
  else if mausback then getmenu:=-3
  else getmenu:=-2;
end;


{ --- Daten laden/speichern ---------------------------------- }

procedure rdjn(var c:char; default:char);
var t : taste;
begin
  c:=default;
  repeat
    write(c,#8);
    get(t,curon);
    if (t='j') or (t='J') or (t='n') or (t='N') then
      c:=UpCase(t[1]);
  until (t=keycr) or (t=keyesc);
end;


procedure readmedata;
var f       : file of integer;
    version : integer;
    c       : char;
    i       : integer;
begin
  anzhidden:=0;
  assign(f,menufile);
  filemode:=$40;
  if existf(f) then begin
    reset(f);
    read(f,version);
    if version<>meversion then begin
      wrlogo;
      writeln('WARNUNG: XPME kann das Format der Mendatei (XPMENU.DAT) nicht');
      writeln('         erkennen. Die Datei wurde entweder mit einer neueren');
      writeln('         Version des Meneditors erstellt oder ist beschdigt.');
      writeln('         Wenn Sie jetzt fortfahren, wird diese Datei gelscht,');
      writeln('         d.h. eventuelle Informationen ber (de)aktivierte');
      writeln('         Menpunkte gehen verloren.');
      writeln;
      write('Fortfahren (J/N)? '#7);
      rdjn(c,'N');
      writeln;
      if c='N' then halt;
      end
    else begin
      read(f,anzhidden);
      anzhidden:=minmax(anzhidden,0,min(maxhidden,filesize(f)-2));
      for i:=1 to anzhidden do
        read(f,hidden[i]);
      c:='N';
      end;
    close(f);
    if c='J' then erase(f);
    end;
end;


procedure writemdata;
var f : file of integer;
    i : integer;
begin
  assign(f,menufile);
  filemode:=2;
  rewrite(f);
  i:=meversion;
  write(f,i);
  write(f,anzhidden);
  for i:=1 to anzhidden do
    write(f,hidden[i]);
  close(f);
  saved:=true;
end;


function askquit:boolean;
var x,y : byte;
    t   : taste;
    c   : char;
begin
  msgbox(34,4,'',x,y);
  wrt(x+3,y+1,'nderungen sichern?');
  t:='';
  case readbutton(x+3,y+3,2,' ^Ja , ^Nein , ^Zurck ',1,true,t) of
    1 : begin
          writemdata;
          askquit:=true;
        end;
    2 : askquit:=true;
    else askquit:=false;
  end;
  closebox;
end;


begin
  readmenus;
  readconfig;
  readcol;
  readmedata;
  showscreen;
  repeat
    if getmenu(0,'',0,0)=0 then;
  until not modi or AskQuit;
  attrtxt(7);
  clrscr;
  setbackintensity(mback);
  wrlogo;
  if saved then writeln('nderungen wurden gesichert.'#10);
end.
