{ --------------------------------------------------------------- }
{ Dieses Programm ist urheberrechtlich geschuetzt.                }
{ (c) 1991-2001 Peter Mandrella                                   }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Sie duerfen dieses Programm unter den Bedingungen der GNU       }
{ General Public License ("GPL") Version 2 der Free Software      }
{ Foundation weitergeben und/oder veraendern.                     }
{                                                                 }
{ Die vollstaendigen Nutzungsbedingungen fuer dieses Programm     }
{ finden Sie in den beiliegenden Dateien SLIZENZ.TXT und COPYING  }
{ oder unter http://www.crosspoint.de/srclicense.html .           }
{ --------------------------------------------------------------- }

{ CrossPoint - Deklarationen }

{$A+}

unit xp0;

interface

uses   dos,typeform,keys,database;


{ Die folgenden drei Konstanten mssen Sie ergnzen, bevor Sie      }
{ CrossPoint compilieren knnen. Falls Die das compilierte Programm }
{ weitergeben mchten, mssen der angegebene Name korrekt und die   }
{ E-Mail-Adresse erreichbar sein (siehe LIZENZ.TXT).                }
{
{ Beispiel:                                                         }
{                                                                   }
{ const  author_name = 'Ralf Mller';                               }
{        author_mail = 'ralf@t-offline.de';                         }
{        x_copyright = '(c) 2001';                                  }
{                                                                   }
{ Diese Informationen werden bei Programmstart und bei              }
{ /XPoint/Registrierung angezeigt.                                  }


const  author_name =
       author_mail =
       x_copyright =


const  {$IFDEF DPMI}
       IsDPMI      = true;
       XLstr       = ' XL';
       {$ELSE}
       IsDPMI      = false;
       XLstr       = '';
       {$ENDIF}

       LangVersion = '13';           { Version des Sprachmoduls }
       menus       = 40;
       ZeilenMenue = 11;
       maxbmark    = 1000;           { maximal markierbare User/Bretter }
       QuoteLen    = 5;              { maximale QuoteChar-Lnge }
       Ablagen     = 20;             { 0..9 }
       maxpmc      = 3;              { installierbare pmCrypt-Verfahren }
       MaxSigsize  = 300;            { maximale Signaturgre (Bytes) }
       maxkeys     = 100;            { s. auch XP10.maxentries }
       excludes    = 4;              { Anzahl Ausschluzeiten  }
       maxskeys    = 15;             { max. Tasten in Zeile 2  }
       mausdefx    = 620;            { Maus-Startposition      }
       mausdefy    = 28;
       MaxNodelists = 100;
       MaxAKAs     = 10;
       maxviewers  = 7;
       defviewers  = 3;
       maxpmlimits = 6;              { Z/Maus/Fido/UUCP/Magic/QMGS     }
       maxheaderlines = 30;
       MaxXposts   = 15;
       MaxCom      = 5;

       BoxNameLen  = 20;             { diese Lngenangaben sollten fr }
       BoxRealLen  = 15;             { alle Bearbeitungs-Variablen fr }
       BrettLen    = 81;             { die entsprechenden Felder ver-  }
       eBrettLen   = 79;             { wendet werden                   }
       AdrLen      = 80;
       eAdrLen     = 79;
       BetreffLen  = 70;
       DateLen     = 11;
       midlen      = 120;
       AKAlen      = 127;
       OrgLen      = 80;             { Organisation }
       PostadrLen  = 80;             { Postadresse }
       TeleLen     = 100;            { Telefon }
       HomepageLen = 90;             { WWW-Homepage }
       hdErrLen    = 60;
       ViewprogLen = 70;             { Kommandozeile fr ext. Viewer }
       ResMinmem   = 340000;

       verstr      = 'v3.2';       { Versionnr. - steht nur an dieser Stelle }
       betastr     = ' beta';      { '' oder ' beta' }
       patchlevel  : string[13] = '*patchlevel*0';
       xp_xp       : string[10] = 'CrossPoint';
       xp_name     : string[30] = '## CrossPoint '+verstr+betastr;  { fr ZConnect-Header }
       xp_origin   : string[15] = '--- CrossPoint';
       xp_short    : string[2]  = 'XP';
       QPC_ID      = 'QPC:';
       DES_ID      = 'DES:';
       PMC_ID      = '*crypted*';
       XPMC_ID     = '*Xcrypted*';
       TO_ID       = '/'#0#0#8#8'TO:';
       TO_len      = length(TO_ID);
       vert_char   = #4;             { Verteiler-Kennung }
       MausinfoBrett= '$/Mausinfo';
       uuserver    = 'UUCP-Fileserver';

       PufferFile  = 'PUFFER';       { Z-Netz-Puffer }
       TPufferFile = 'TPUFFER';      { TurboBox-Puffer }
       XFerDir     = 'SPOOL\';       { eingehende Mailbatches }
       XFerDir_    = 'SPOOL';
       JanusDir    = 'SPOOL\JANUS\';
       JanusDir_   = 'SPOOL\JANUS';
       FidoDir     = 'FIDO\';        { Nodelists }
       FidoDir_    = 'FIDO';
       InfileDir   = 'FILES\';       { Default: Filerequests }
       AutoxDir    = 'AUTOEXEC\';    { AutoStart-Daten }
       BadDir      = 'BAD\';

       HeaderFile  = 'header.xps';     { Schablonen-Dateien }
       HeaderPriv  = 'privhead.xps';
       SignatFile  = 'signatur.xps';
       PrivSignat  = 'privsig.xps';
       QuoteMsk    = 'qbrett.xps';
       QuotePriv   = 'qpriv.xps';
       QuotePMpriv = 'qpmpriv.xps';
       QuoteToMsk  = 'quoteto.xps';
       WeiterMsk   = 'weiter.xps';
       ErneutMsk   = 'erneut.xps';
       EB_Msk      = 'empfbest.xps';
       CancelMsk   = 'cancel.xps';

       BfgExt      = '.BFG';           { Boxen-Config-File }
       QfgExt      = '.QFG';           { QWK-Config-File   }
       SwapExt     = '.SWP';

       MsgFile     = 'MSGS';           { DB1-Dateinamen }
       BrettFile   = 'BRETTER';
       UserFile    = 'USER';
       BoxenFile   = 'BOXEN';
       GruppenFile = 'GRUPPEN';
       SystemFile  = 'SYSTEME';
       DupeFile    = 'DUPEKILL';       { temporr in XP4O.DupeKill }
       AutoFile    = 'AUTOMSG';
       PseudoFile  = 'PSEUDOS';
       BezugFile   = 'BEZUEGE';
       MimetFile   = 'MIMETYP';

       CfgFile     = 'xpoint.cfg';     { verschiedene Dateien }
       Cfg2File    = 'xpoint2.cfg';
       ColCfgfile  = 'xpoint.col';
       NewDateFile = 'neues.dat';
       MsgTempFile = 'msg.tmp';
       AblagenFile = 'mpuffer.';
       UncryptedFile = 'crypt.msg';
       CryptedFile = 'crypt.enc';
       TimingFile  = 'timing.';
       TimingDat   = 'timing.dat';
       KilledDat   = 'reorg.dat';
       CCfile      = 'verteil.dat';
       FidoCfg     = 'fido.cfg';
       OldNLCfg    = FidoDir+'nodelist.cfg';
       NodelistCfg = FidoDir+'nodelst.cfg';
       NodeindexF  = FidoDir+'nodelist.idx';
       UserindexF  = FidoDir+'nodeuser.idx';
       ARCmailDat  = 'arcmail.dat';
       FileLists   = FidoDir+'filelist.cfg';
       ReqDat      = 'request.dat';    { Crashs + Requests }
       RegDat      = 'regdat.xp';
       UUnumdat    = 'uunummer.dat';
       FeierDat    = 'feiertag.dat';
       PGPkeyfile  = 'pgp-key.bin';
       menufile    = 'xpmenu.dat';
       CrashTemp   = 'crash.tmp';

       ErrlogFile  = 'errors.log';     { LogFiles }
       Logfile     = 'xpoint.log';
       BiLogFile   = 'logfile';        { fr BiModem-bertragung }
       BrettlogFile= 'bretter.log';    { automatisch angelegte Bretter }
       UserlogFile = 'user.log';       { automatisch angelegte User }
       DupeLogfile = 'dupes.log';      { s. XP4.DupeKill }
       MausLogfile = 'maus.log';       { MAGGI: MausTausch-Logfile }
       MausPmLog   = 'mauspm.log';     { MAGGI: MausTausch-PM-Logfile }
       MausStLog   = 'mausstat.log';   { MAGGI: MausTausch-Nachrichtenstati }
       FidoLog     = 'xpfido.log';     { XP-FM-Logfile   }
       UUCPlog     = 'xpuucp.log';     { uucico-Logfile  }
       ScerrLog    = 'scerrors.log';   { Script-Fehler   }
       NetcallLog  = 'netcall.log';    { Netcall-Logfile }

       miBrett     = 1;                { BRETTNAME/EMPFDATUM/INT_NR         }
       miGelesen   = 2;                { BRETTNAME/GELESEN/EMPFDATUM/INT_NR }
       uiName      = 1;                { User:    +USERNAME                 }
       uiAdrbuch   = 2;                {          ADRBUCH/+USERNAME         }
       biBrett     = 1;                { Bretter: BRETTNAME                 }
       biGruppe    = 2;                {          GRUPPE                    }
       biIntnr     = 3;                {          INT_NR                    }
       biIndex     = 4;                {          INDEX                     }
       giName      = 1;                { Gruppen: +NAME                     }
       giIntnr     = 2;                {          INT_NR                    }
       boiName     = 1;                { Boxen:   +BOXNAME                  }
       boiDatei    = 2;                {          +DATEINAME                }
       siName      = 1;                { Systeme: +NAME                     }
       aiBetreff   = 1;                { AutoMsg: +BETREFF                  }
       piKurzname  = 1;                { Pseudos: +KURZNAME                 }
       beiMsgID    = 1;                { Bezuege: MsgID                     }
       beiRef      = 2;                {          Ref                       }
       mtiTyp      = 1;                { MimeType: +TYP                     }
       mtiExt      = 2;                {           +EXTENSION               }

       rmUngelesen = 1;                { ReadMode: Lesen/Ungelesen  }
       rmNeues     = 2;                { ReadMode: Lesen/Neues      }
       rmHeute     = 3;                { ReadMode: Lesen/Heute      }

       MaxHdsize   = 2000;             { maximal *erzeugte* Headergre }

       AttrQPC     = $0001;            { QPC-codierte Nachricht     }
       AttrCrash   = $0002;            { header.attrib: Crashmail   }
       AttrPmcrypt = $0004;            { pmCrypt-codierte Nachricht }
       AttrIgate   = $0008;            { IGATE.EXE-Nachricht        }
       AttrFile    = $0010;            { File attached              }
       AttrControl = $0020;            { Cancel-Nachricht           }
       AttrMPbin   = $0040;            { Multipart-Binary           }
       AttrPmReply = $0100;            { PM-Reply auf AM (Maus/RFC) }
       AttrQuoteTo = $0400;            { QuoteTo (Maus)             }
       AttrReqEB   = $1000;            { EB anfordern               }
       AttrIsEB    = $2000;            { EB                         }

       fPGP_encoded  = $0001;          { Nachricht ist PGP-codiert  }
       fPGP_avail    = $0002;          { PGP-Key vorhanden          }
       fPGP_signed   = $0004;          { Nachricht ist mit PGP sign.}
       fPGP_clearsig = $0008;          { Clear-Signatur             }
       fPGP_sigok    = $0010;          { Signatur war ok            }
       fPGP_sigerr   = $0020;          { Signatur war fehlerhaft    }
       fPGP_please   = $0040;          { Verifikations-Anforderung  }
       fPGP_request  = $0080;          { Key-Request                }
       fPGP_haskey   = $0100;          { Nachricht enthlt PGP-Key  }
       fPGP_comprom  = $0200;          { Nachricht enthlt compromise }

       fattrHalten   = $0001;          { Nachricht auf "halten"     }
       fattrLoeschen = $0002;          { Nachricht auf "lschen"    }
       fattrGelesen  = $0004;          { Nachricht auf "gelesen"    }
       fattrHilite   = $0008;          { Nachricht hervorheben      }

       maxkomm    = 5000;              { Kommentarbaum }
       kflLast    = 1;
       kflBetr    = 2;
       kflPM      = 4;
       kflBrett   = 8;                 { Brettwechsel }

       hdf_Trenn  = 0;                 { Nummern fr Header-Felder }
       hdf_EMP    = 1;
       hdf_ABS    = 2;
       hdf_BET    = 3;        hdf_OAB     = 13;     hdf_TEL      = 23;
       hdf_EDA    = 4;        hdf_OEM     = 14;     hdf_MSTAT    = 24;
       hdf_ROT    = 5;        hdf_WAB     = 15;     hdf_KOP      = 25;
       hdf_MID    = 6;        hdf_ERR     = 16;     hdf_PGPSTAT  = 26;
       hdf_LEN    = 7;        hdf_ANTW    = 17;     hdf_Homepage = 27;
       hdf_BEZ    = 8;        hdf_DISK    = 18;     hdf_Part     = 28;
       hdf_MAILER = 9;        hdf_STW     = 19;
       hdf_FILE   = 10;       hdf_ZUSF    = 20;
       hdf_STAT   = 11;       hdf_DIST    = 21;
       hdf_ORG    = 12;       hdf_POST    = 22;


type   textp  = ^text;
       ColArr = array[0..3] of byte;
       ColQArr= array[1..9] of byte;
       ColRec = record
                  ColMenu       : ColArr; { Normaler Mentext       }
                  ColMenuHigh   : ColArr; { Direkt-Buchstaben       }
                  ColMenuInv    : ColArr; { Men-Balken             }
                  ColMenuInvHi  : ColArr; { Men-Balken/Buchstabe   }
                  ColMenuDis    : ColArr; { Men disabled           }
                  ColMenuSelDis : ColArr; { Men disabled/gewhlt   }
                  ColKeys       : byte;   { Direkttasten            }
                  ColKeysHigh   : byte;   { Direkttasten-Buchstaben }
                  ColKeysAct    : byte;   { aktivierte Taste        }
                  ColKeysActHi  : byte;   { aktivierter Buchstabe   }
                  ColTLine      : byte;   { Trennlinie              }
                  ColBretter    : byte;   { User / Bretter          }
                  ColBretterInv : byte;   { User / Bretter, gewhlt }
                  ColBretterHi  : byte;   { User / Bretter, markiert}
                  ColBretterTr  : byte;   { Trennzeile              }
                  ColMsgs       : byte;   { Msgs                    }
                  ColMsgsHigh   : byte;   { Msgs, markiert          }
                  ColMsgsInv    : byte;   { Msgs, gewhlt           }
                  ColMsgsInfo   : byte;   { Msgs, 1. Zeile          }
                  ColMsgsUser   : byte;   { PM-archivierte Msgs     }
                  ColMsgsInvUser: byte;   { gewhlt+hervorgehoben   }
                  ColMbox       : byte;   { Meldungs-Box, Text      }
                  ColMboxRahmen : byte;   { Meldungs-Box, Rahmen    }
                  ColMboxHigh   : byte;   { Meldungs-Box, hervorgeh.}
                  ColDialog     : byte;   { Dialoge, Feldnamen u.. }
                  ColDiaRahmen  : byte;   { Dialogbox, Rahmen       }
                  ColDiaHigh    : byte;   { Dialogbox, hervorgeh.T. }
                  ColDiaInp     : byte;   { Dialogbox, Eingabefeld  }
                  ColDiaMarked  : byte;   { Dial., markierter Text  }
                  ColDiaArrows  : byte;   { Pfeile bei Scrollfeldern}
                  ColDiaSel     : byte;   { Masken-Auswahlliste     }
                  ColDiaSelBar  : byte;   {            "            }
                  ColDiaButtons : byte;   { Check/Radio-Buttons     }
                  ColSelbox     : byte;   { Auswahlbox              }
                  ColSelRahmen  : byte;   { Auswahlbox, Rahmen      }
                  ColSelHigh    : byte;   { Auswahlbox, hervorgeh.  }
                  ColSelBar     : byte;   { Auswahlbox, Balken      }
                  ColSelBarHigh : byte;   { Auswahlbox, Balken/hv.  }
                  ColSel2box    : byte;   { Auswahlbox / dunkel     }
                  ColSel2Rahmen : byte;   { Auswahlbox, Rahmen      }
                  ColSel2High   : byte;   { Auswahlbox, hervorgeh.  }
                  ColSel2Bar    : byte;   { Auswahlbox, Balken      }
                  ColButton     : byte;   { Button                  }
                  ColButtonHigh : byte;   { Button - Hotkeys        }
                  ColButtonArr  : byte;   { aktiver Button: Pfeile  }
                  ColUtility    : byte;   { Kalender u..           }
                  ColUtiHigh    : byte;
                  ColUtiInv     : byte;
                  ColHelp       : byte;   { Hilfe normal            }
                  ColHelpHigh   : byte;   { hervorgehobener Text    }
                  ColHelpQVW    : byte;   { Querverweis             }
                  ColHelpSlQVW  : byte;   { gewhlter Querverweis   }
                  ColListText   : byte;   { Lister, normaler Text   }
                  ColListMarked : byte;   { Lister, markiert        }
                  ColListSelbar : byte;   { Lister, Auswahlbalken   }
                  ColListFound  : byte;   { Lister, nach Suche mark.}
                  ColListStatus : byte;   { Lister, Statuszeile     }
                  ColListQuote  : ColQArr; { Quote-Zeilen + Maps"J" }
                  ColListScroll : byte;   { vertikaler Scroller     }
                  ColListHeader : byte;   { Nachrichtenkopf         }
                  ColListHigh   : byte;   { *hervorgehoben*         }
                  ColListQHigh  : ColQArr; { Quote / *hervorgehoben* }
                  ColEditText   : byte;   { Editor, normaler Text   }
                  ColEditStatus : byte;   { Editor, Statuszeile     }
                  ColEditMarked : byte;   { Editor, markierter Blck.}
                  ColEditMessage: byte;   { Editor-Meldung          }
                  ColEditHead   : byte;   { TED: Info-Kopf          }
                  ColEditQuote  : ColQArr; { TED: farbige Quotes     }
                  ColEditEndmark: byte;   { TED: Endmarkierung      }
                  ColEditMenu   : byte;   { TED: Men               }
                  ColEditMenuHi : byte;   { TED: Hotkey             }
                  ColEditMenuInv: byte;   { TED: Selbar             }
                  ColEditHiInv  : byte;   { TED: gewhlter Hotkey   }
                  ColArcStat    : byte;   { Status-Zeile ArcViewer  }
                  ColMapsBest   : byte;   { bestellte Bretter       }
                  ColMailer     : byte;   { Fido-Mailer/uucico      }
                  ColMailerhigh : byte;   { .. hervorgehoben #1     }
                  ColMailerhi2  : byte;   { .. hervorgehoben #2     }
                  ColBorder     : byte;   { Rahmenfarbe             }
                end;

       { alle nicht genutzen Headerzeilen sollten = 0 sein         }
       { Netztypen: 0=Netcall, 1=Pointcall, 2=ZConnect, 3=MagicNET }
       {            10=QM, 11=GS, 20=Maus, 30=Fido, 40=RFC         }
       {            90=Turbo-Box                                   }

       OrgStr      = string[OrgLen];
       AdrStr      = string[AdrLen];
       TeleStr     = string[TeleLen];
       HomepageStr = string[HomepageLen];
       pviewer     = ^string;

       refnodep= ^refnode;             { Datentyp fr Reference-Liste }
       refnode = record
                   next  : refnodep;
                   ref   : string[midlen];
                 end;
       empfnodep=^empfnode;
       empfnode= record
                   next   : empfnodep;
                   empf   : AdrStr;
                 end;

       header = record
                  netztyp    : byte;          { --- intern ----------------- }
                  archive    : boolean;       { archivierte PM               }
                  attrib     : word;          { Attribut-Bits                }
                  filterattr : word;          { Filter-Attributbits          }
                  empfaenger : string[90];    { --- allgemein --- Brett / User / TO:User }
                  kopien     : empfnodep;     { KOP: - Liste }
                  empfanz    : integer;       { Anzahl EMP-Zeilen }
                  betreff    : string[BetreffLen];
                  absender   : string[80];
                  datum      : string[11];    { Netcall-Format               }
                  zdatum     : string[22];    { ZConnect-Format; nur auslesen }
                  orgdate    : boolean;       { Ausnahme: zdatum schreiben   }
                  pfad       : string;        { Netcall-Format               }
                  msgid,ref  : string[midlen];{ ohne <>                      }
                  refanz     : integer;       { Anzahl BEZ-Zeilen            }
                  typ        : string[1];     { T / B                        }
                  crypttyp   : string[1];     { '' / T / B                   }
                  charset    : string[7];
                  ccharset   : string[7];     { crypt-content-charset }
                  groesse    : longint;
                  realname   : string[40];
                  programm   : string[40];    { Mailer-Name }
                  organisation : OrgStr;
                  postanschrift: string[PostAdrLen];
                  telefon    : TeleStr;
                  homepage   : HomepageStr;
                  PmReplyTo  : AdrStr;        { Antwort-An    }
                  AmReplyTo  : AdrStr;        { Diskussiom-In }
                  amrepanz   : integer;       { Anzahl Diskussion-in's }
                  komlen     : longint;       { --- ZCONNECT --- Kommentar-Lnge }
                  ckomlen    : longint;       { Crypt-Content-KOM }
                  datei      : string[40];    { Dateiname                  }
                  ddatum     : string[14];    { Dateidatum, jjjjmmtthhmmss }
                  prio       : byte;          { 10=direkt, 20=Eilmail      }
                  error      : string[hdErrLen]; { ERR-Header              }
                  oem,oab,wab: AdrStr;
                  oar,war    : string[40];    { Realnames }
                  real_box   : string[20];    { --- Maggi --- falls Adresse = User@Point }
                  hd_point   : string[25];    { eigener Pointname }
                  pm_bstat   : string[20];    { --- Maus --- Bearbeitungs-Status }
                  org_msgid  : string[120];
                  org_xref   : string[120];
                  ReplyPath  : string[8];
                  ReplyGroup : string[40];    { Kommentar-zu-Gruppe          }
                  fido_to    : string[36];    { --- Fido ------------------- }
                  x_charset  : string[25];    { --- RFC -------------------- }
                  keywords   : string[60];
                  summary    : string[200];
                  distribution:string[40];
                  pm_reply   : boolean;       { Followup-To: poster }
                  quotestring: string[20];
                  empfbestto : string[AdrLen];
                  pgpflags   : word;          { PGP-Attribut-Flags           }
                  pgp_uid    : string[80];    { alternative Adresse          }
                  vertreter  : string[80];
                  XPointCtl  : longint;
                  nokop      : boolean;
                  boundary   : string[70];    { MIME-Multipart-Boundary      }
                  mimetyp    : string[30];
                end;
       headerp = ^header;

       markrec  =  record
                     recno : longint;
                     datum : longint;
                     intnr : longint;
                   end;

       marklist = array[0..5000] of markrec;
       marklistp= ^marklist;
       bmarklist= array[0..maxbmark-1] of longint;
       bmarkp   = ^bmarklist;

       ComRec = record
                  Fossil : boolean;
                  Cport  : word;        { UART-Adresse   }
                  Cirq   : byte;        { 0..7           }
                  MInit  : ^string;
                  MExit  : ^string;
                  MDial  : ^string;     { Whlbefehl     }
                  Warten : byte;        { Warten auf Modem-Antwort }
                  IgCD   : boolean;     { CD ignorieren  }
                  IgCTS  : boolean;     { CTS ignorieren }
                  UseRTS : boolean;     { RTS-Handshake  }
                  Ring   : boolean;     { RING-Erkennung }
                  u16550 : boolean;     { FIFO verwenden }
                  postsperre : boolean; { 30-Sek.-Minimalwhlpause }
                  tlevel : byte;        { FIFO trigger level }
                end;

       BoxRec = record
                  boxname   : string[20];   { redundant; wird aus .. }
                  pointname : string[25];
                  username  : string[30];
                  _domain   : string[60];   { .. BOXEN.DB1 kopiert   }
                  passwort  : string[20];
                  telefon   : string[60];
                  zerbid    : string[4];
                  uploader  : string[127];
                  downloader: string[127];
                  zmoptions : string[60];
                  prototyp  : string[1];    { Protokoll-Typ /Maus }
                  uparcer   : string[100];
                  downarcer : string[100];
                  unfreezer : string[40];
                  ungzipper : string[40];
                  uparcext  : string[3];
                  downarcext: string[3];
                  connwait  : integer;
                  loginwait : integer;
                  redialwait: integer;
                  redialmax : integer;
                  connectmax: integer;
                  packwait  : integer;
                  retrylogin: integer;
                  conn_time : integer;      { Modem-Connect-Zeit }
                  owaehlbef : string[10];   { wird nicht mehr verwendet! }
                  modeminit : string[60];
                  mincps    : integer;
                  bport     : byte;
                  params    : string[3];
                  baud      : longint;
                  gebzone   : string[20];
                  SysopInp  : string[60];  { Eingabe-Puffer fr SysMode }
                  SysopOut  : string[60];  { Zieldatei fr Sysop-Mode  }
                  SysopStart: string[60];
                  SysopEnd  : string[60];
                  O_passwort: string[25];  { Online-Pawort }
                  O_logfile : string[60];  { Online-Logfile }
                  O_script  : string[45];  { Online-Script  }
                  MagicNet  : string[8];   { Name des MagicNet's..     }
                  MagicBrett: string[25];  { Bretthierarchie fr Magic }
                  lightlogin: boolean;     { LightNET-Login: \ statt ^F}
                  exclude   : array[1..excludes,1..2] of string[5];
                  FPointNet : word;        { Fido: Pointnetz-Nr.       }
                  f4D       : boolean;     { Fido: 4D-Adressen         }
                  fTosScan  : boolean;     { Fido: Box benutzt TosScan }
                  AreaPlus  : boolean;     { Fido: "+" bei AreaFix     }
                  AreaBetreff:boolean;     { Fido: -q / -l             }
                  AreaPW    : string[12];  { Fido/UUCP: Areafix-PW     }
                  FileScanner:string[15];  { Fido: Filescan-Name       }
                  FilescanPW: string[12];  { Fido: Filescan-Pawort    }
                  EMSIenable: boolean;     { Fido: EMSI mglich        }
                  AKAs      : string[AKAlen]; { Fido: lokale AKA-Liste }
                  SendAKAs  : string[AKAlen]; { Fido: Pakete mitsenden fr.. }
                  GetTime   : boolean;     { Fido: TRX#-Zeit setzen    }
                  SendTrx   : boolean;     { Fido: TRX# senden - undok }
                  NotSEmpty : boolean;     { Fido: kein sendempty - "  }
                  PacketPW  : boolean;     { Fido: Paketpawort senden }
                  ExtPFiles : boolean;     { Fido: erweiterte Paketdateinamen }
                  LocalIntl : boolean;     { Fido: ~d'Bridge-Areafix   }
                  Brettmails: boolean;     { Turbo-Box/Maus:  Brettnachr. }
                  LoginName : string[20];  { UUCP/QM: login-Username   }
                  UUCPname  : string[8];   { uucico-Systemname         }
                  MaxWinSize: byte;        { UUCP: max. Windowgre    }
                  MaxPacketSize:word;      { UUCP: max. Blockgre     }
                  VarPacketSize:boolean;   { UUCP: variable Blockgre }
                  ForcePacketSize:boolean; { UUCP: SendWinsize=RecvWinsize }
                  UUprotos  : string[10];  { UUCP: mgl. Protokolle    }
                  SizeNego  : boolean;     { UUCP: size negotiation    }
                  UUsmtp    : boolean;     { UUCP: SMTP                }
                  eFilter   : string[60];  { Eingangsfilter            }
                  aFilter   : string[60];  { Ausgangsfilter            }
                  SysopNetcall : boolean;  { Netzanruf-Bericht im S.M. }
                  SysopPack : boolean;     { Sysopnetcall-Paket packen }
                  SerienNr  : word;        { Turbo-Box: Seriennr.      }
                  Script    : string[50];  { Netcall-Script     }
                  chsysbetr : string[50];  { Changesys-Betreff  }
                  uucp7e1   : boolean;     { gerade Parity beim Login }
                  JanusPlus : boolean;     { Janus+             }
                  DelQWK    : boolean;     { ZQWK-Schalter -del }
                  BMtyp     : byte;        { UUCP: Brettmanager-Typ }
                  BMdomain  : boolean;     { UUCP: Brettmanager braucht Domain }
                  maxfsize  : word;        { UUCP: max. Empfangsdateigre / KB }
                end;
       BoxPtr = ^BoxRec;

       QfgRec = record                     { QWK-QFG-Daten }
                  RepFile   : string[8];   { REP-Dateinahme ohne Ext. }
                  Packer    : string[3];   { Packer-Typ (Extension)   }
                  Door      : string[20];  { Name des Doorprogramms   }
                  requests  : boolean;     { File Requests mglich    }
                  ebs       : boolean;     { Empfangsbesttigungen "  }
                  privecho  : string[50];  { PM-Echo                  }
                  netecho   : string[50];  { Netmail-Echo             }
                  emailecho : string[50];  { EMail-Echo (Oerx)        }
                  nmt       : byte;        { Netmail-Typ              }
                  midtyp    : shortint;    { Message-ID-Typ           }
                  hdr       : boolean;     { Header im Body           }
                  bretter   : string[25];  { Brettebene               }
                end;

       FidoAdr = record
                   username   : string[36];
                   zone,net   : word;
                   node,point : word;
                   ispoint    : boolean;
                 end;

       NL_Rec  = record
                   listfile   : string[12];    { Nodelisten-Datei      }
                   number     : integer;       { akt. Nummer           }
                   updatefile : string[12];    { Diff/Update-Datei     }
                   updatearc  : string[12];    { gepackte Update-Datei }
                   processor  : ^string;       { externer Bearbeiter   }
                   DoDiff     : boolean;
                   DelUpdate  : boolean;       { Diff lschen }
                   format     : byte;     { 1=NL, 2=P24, 3=PVT, 4=4D, 5=FD }
                   zone,net,node : word;
                   sort       : longint;       { Temporrfeld }
                 end;
       NL_array= array[1..maxNodelists] of NL_Rec;
       NL_ap   = ^NL_array;

       fkeyt  = array[1..10] of record
                                  menue    : string[20];
                                  prog     : string[60];
                                  warten   : boolean;
                                  bname    : boolean;  { $FILE aus Betreff }
                                  ntyp     : byte;   { xp3.extract_msg.typ }
                                  listout  : boolean;  { Ausgabe an Lister }
                                  speicher : word;       { 50 .. 500 KByte }
                                  vollbild : boolean;
                                  autoexec : boolean;
                                end;
       fkeyp  = ^fkeyt;

       KeyRec = record
                  keypos : byte;   { X-Position in 2. Bildzeile }
                  keylen : byte;
                  keyspot: shortint;  { <0 : mehrere Zeichen ab Pos. 0 }
                  key    : taste;  { LowerCase-Taste }
                end;

       proc   = procedure;

       komrec   = record
                    msgpos : longint;
                    lines  : longint;
                    _ebene : shortint;
                    flags  : byte;
                  end;
       komliste = array[0..maxkomm-1] of komrec;   { Kommentarbaum }
       komlistp = ^komliste;

       ExtHeaderType = array[1..maxheaderlines] of byte;

       viewert  = array[1..maxviewers] of record
                                            ext : string[3];
                                            prog: string[40];
                                          end;
       UnpackRec = record
                     UnARC, UnLZH, UnZOO,
                     UnZIP, UnARJ, UnPAK,
                     UnDWC, UnHYP, UnSQZ,
                     UnRAR                : string[50];
                   end;

       PathPtr   = ^pathstr;

       DomainNodeP = ^domainnode;
       DomainNode = record
                      left,right : DomainNodeP;
                      domain     : ^string;
                    end;


const  menupos : array[0..menus] of byte = (1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                                            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                                            1,1,1,1,1,1,1);
       menable : array[0..menus] of word = (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                            0,0,0,0,0,0,0);
       checker : array[0..menus] of byte = (0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,0,0,
                                            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                            0,0,0,0,0,0,0);

       OStype : (os_dos,os_windows,os_2) = os_dos;

       Quit       : boolean = false;
       mbase      : pointer = nil;     { Nachrichten.Datenbank  }
       ubase      : pointer = nil;     { User-Datenbank         }
       bbase      : pointer = nil;     { Brett-Datenbank        }
       auto       : pointer = nil;     { automsg.db1            }
       bezbase    : pointer = nil;     { Bezugs-Datenbank       }
       mimebase   : pointer = nil;     { MIME-Typen-Datenbank   }
       runerror   : boolean = true;    { Runtime Error aufgetreten }
       Timing_Nr  : byte = 1;          { zuletzt eingegebene Nummer}
       ErrLevel   : byte = 0;          { bei Beenden ber XP.PAS   }
       startup    : boolean = true;    { Datenbank noch nicht initialisier }
       netcalling : boolean = false;   { laufender Netcall }
       autoactive : boolean = false;   { select(20) aktiv  }
       extended   : boolean = false;
       keydisp    : boolean = true;    { Tastenkrzel anzeigen  }
       Clipboard  : boolean = false;   { Windows-Clipboard }
       deutsch    : boolean = true;
       screenlines: byte    = 25;      { Bildschirmzeilen       }
       screenwidth: byte    = 80;      { Bildschirmspalten      }
       OrgVideomode:word    = 3;
       uvs_active : boolean = false;   { /N/Z/Unversandt        }
       marksorted : boolean = false;   { marked^[] sortiert     }
       fidolastseek:string[28] = '';   { Fido/Fileliste/Suchen  }
       abgelaufen1: boolean = false;   { Betaversion ist abgelaufen }
       abgelaufen2: boolean = false;   {  " }
       cfgmodified: boolean = false;   { Einstellungen gendert }
       DisableAltN: boolean = false;   { Alt-N deaktiviert      }
       automessaging: boolean = false; { Nachrichten werden nicht-manuell }
       actscreenlines: integer = 25;
       exzconfig  : boolean = false;   { exist('zconfig.exe') -> /C/A/P }
                                       { verarbeitet (whren P.-Einlesen  }
       lockopen   : boolean = false;   { LOCKFILE geffnet }

       XPhilite   : byte    = 20;
       XPdisplayed: boolean = false;   { 'CrossPoint' rechts unten angezeigt }

       ParHelp    : boolean = false;   { Hilfsseite             }
       ParDebug   : boolean = false;   { Debugging-Mode         }
       ParDDebug  : boolean = false;   { Database-Debug         }
       ParDebFlags: byte    = 0;       { 1 = Shell-Commands     }
       ParTrace   : boolean = false;   { Script-Tracefile       }
       ParMono    : boolean = false;   { monochrome Anzeige     }
       ParNojoke  : boolean = false;   { Spruch am Ende abschalten }
       ParXX      : boolean = false;   { s. XP4E                }
       ParNetcall : string[BoxNameLen] = '';  { autom. Netcall }
       ParNCtime  : string[5] = '';    { Uhrzeit f. autom. Netcall }
       ParRelogin : boolean = false;   { Relogin-Netcall        }
       ParReorg   : boolean = false;   { autom. Reorganisation  }
       ParSpecial : boolean = false;   { Spezial-Reorg - Puffer-reparieren }
       ParPack    : boolean = false;   { autom. Packen          }
       ParXPack   : boolean = false;   { autom. Packen / nur Dateien mit Lcken }
       ParXPfile  : string[8] = '';    { optional zu /xpack: Datenbankname }
       ParQuiet   : boolean = false;   { keine Gerusche        }
       ParTestres : boolean = true;    { Test auf residente Prg. }
       ParMaus    : boolean = false;   { Pseudo-Maus            }
       ParPuffer  : pathstr = '';      { autom. Puffer einlesen }
       ParPufED   : boolean = false;   { -> EmpfDat = ErstDat   }
       ParGelesen : boolean = false;   { ip-eingelesene Nachrichten auf }
       ParTiming  : byte    = 0;       {    'gelesen' setzen    }
       ParExit    : boolean = false;   { Programm beenden       }
       ParSetuser : string[50] = '';   { Username setzen        }
       ParSendbuf : pathstr = '';      { Puffer automatisch versenden }
       ParKey     : char    = ' ';     { autom. Tastendruck     }
       ParEmpfbest: boolean = false;   { Zusatzschalter fr /IPx }
       ParPass    : string[10] = '';   { * -> ausgeben; Hex -> setzen }
       ParPasswd  : string[10] = '';   { Pawort }
       ParZeilen  : byte = 0;          { Bildzeilen }
       ParWintime : boolean = false;   { Rechenleistungs-Freigabe }
       ParOS2     : byte    = 0;       { Rechenleistungs-Freigabe }
       ParSsaver  : boolean = false;   { Screensaver }
       ParAutost  : string[12] = '';   { /autostart: }
       ParGebdat  : string[12] = 'gebuehr.dat';  { Gebhrenzonenliste }
       ParGebdat2 : string[12] = 'tarife.dat';   { 2. Teil der " }
       ParAV      : pathstr = '';      { Archiv-Viewer }
       ParLanguage: string[4] = '';    { /l: Sprache }
       ParFontfile: pathstr = '';      { /f: Fontdatei laden }
       ParNomem   : boolean = false;   { Speichertest bergehen }
       ParNoSmart : boolean = false;   { kein Schreibcache-Flush }
       ParLCD     : boolean = false;   { keine Int10/CharGen-Zugriffe }
       ParMenu    : boolean = false;   { /menu: XP mit vollen Mens starten }
       ParG1      : boolean = false;   { Gebhrenzone ermitteln }
       ParG2      : boolean = false;   { Gebhren berechnen }
       ParNolock  : boolean = false;   { keine Lockfile-berprfung }

       MoreMode   : boolean = true;
       Developer  : boolean = false;
       SupportCfg : string[12] = 'SUPPORT.CFG';


var    bb_brettname,bb_kommentar,bb_ldatum,bb_flags,bb_pollbox,bb_haltezeit,
       bb_gruppe,bb_index,bb_adresse,
       ub_username,ub_adresse,ub_kommentar,ub_adrbuch,ub_pollbox,
       ub_haltezeit,ub_userflags,ub_codierer,
       mb_brett,mb_absender,mb_betreff,mb_origdatum,mb_empfdatum,
       mb_groesse,mb_typ,mb_halteflags,mb_gelesen,mb_unversandt,
       mb_ablage,mb_adresse,mb_msgsize,mb_wvdatum,mb_msgid,mb_netztyp,
       mb_name,mb_flags,mb_mimetyp,
       bezb_msgpos,bezb_msgid,bezb_ref,bezb_datum,
       mimeb_typ,mimeb_extension,mimeb_programm : integer;

       IntGruppe,LocGruppe,NetzGruppe : longint;   { INT_NRs der Std.-Gruppen }

       menu         : array[0..menus] of ^string;
       SwapFileName : string[12];
       helpfile     : string[12];     { XP.HLP     }
       keydeffile   : string[12];     { KEYDEF.CFG }
       OwnPath      : pathstr;
       ShellPath    : pathstr;
       TempPath     : pathstr;
       ExtractPath  : pathstr;
       SendPath     : pathstr;
       LogPath      : pathstr;
       FilePath     : pathstr;
       FidoPath     : pathstr;       { OwnPath+FidoDir }
       lockfile     : file;          { gelockte Datei LOCKFILE }

       EditLogpath  : pathptr;
       EditTemppath : pathptr;
       EditExtpath  : pathptr;
       EditSendpath : pathptr;

       col          : ColRec;        { CFG-Variablen :  ------ }
       ExtraktTyp   : byte;          { 0=ohne Kopf, 1=mit, 2=Puffer, 3=Quote }
       defExtrakttyp: byte;          { .. in XPOINT.CFG        }
       brettanzeige : byte;          { 0=gross, 1=top, 2=klein }
       ShowMsgDatum : boolean;       { Datum im Nachrichtenf.  }
       viewers      : ^viewert;
       VarEditor,
       VarLister    : string[40];    { externer Editor/Lister  }
       ListerKB     : word;
       EditorKB     : word;
       stdhaltezeit,
       stduhaltezeit: integer;
       QuoteChar    : string[QuoteLen];
       QuoteBreak   : byte;          { Zeilenumbruch fr Quoter }
       COMn         : array[1..MaxCom] of ComRec;  { Schnitten-Paras }
       BoxPar       : BoxPtr;
       DefaultBox   : string[20];
       DefFidoBox   : string[20];
   {}  LongNames    : boolean;       {   "       "         : >40 Zeichen }
       ScrSaver     : word;
       SoftSaver    : boolean;       { Bild weich ausblenden }
       BlackSaver   : boolean;       { schwarzschalten }
       smallnames   : boolean;       { kleingeschriebene Brett/Usernamen }
       UserAufnahme : byte;          { 0=Alle, 1=Zerberus, 2=keine, 3=PM }
       MaxBinSave   : longint;
       MaxNetMsgs   : longint;       { Default-Wert fr neue Gruppen }
       ReHochN      : boolean;
       SwapToEMS    : boolean;       { EMS-Swapper fr DOS-Shell }
       SwapToXMS    : boolean;       { XMS-Swapper fr DOS-Shell }
       HayesComm    : boolean;
       ShowLogin    : boolean;
       BreakLogin   : boolean;
       ArchivBretter: string[BrettLen];
       ArchivLoesch : boolean;       { Msgs nach Archivierung lschen }
       shell25      : boolean;       { 25-Zeilen-Mode bei DOS-Shell }
       edit25       : boolean;       { dito bei externem Editor }
       MinMB        : word;
       AskQuit      : boolean;
       ListVollbild : boolean;       { Vollbild bei internem Lister }
       ListEndCR    : boolean;       { internen Lister mit <cr> beenden }
       ListWrap     : boolean;
       FKeys        : array[0..3] of fkeyp;
       Unpacker     : ^UnpackRec;
       EditVollbild : boolean;
       ExtEditor    : byte;          { 3=immer, 2=Nachrichten, 1=groe Files }
       ShowMsgPath  : boolean;
       ShowMsgID    : boolean;
       ShowMsgSize  : boolean;
       DruckLPT     : word;          { 1-5: LPT1-3, COM1-2 }
       DruckInit    : string[80];
       DruckExit    : string[80];
       DruckFormlen : byte;          { Seitenlnge; 0 = kein autom. Vorschub }
       DruckFF      : string[80];
       DruckLira    : byte;
       AutoCpgd     : boolean;       { automatisches Ctrl-PgDn im Editor }
       XP_ID_PMs    : boolean;
       XP_ID_AMs    : boolean;
       UserSlash    : boolean;
       BAKext       : string[3];
       keepedname   : boolean;
       pmcrypt      : array[1..maxpmc] of
                        record
                          encode,decode : string[40];
                          name          : string[20];
                          binary        : boolean;
                        end;
       wpz          : longint;       { DM/Zeile bei Gebhrenstat. *1000  }
       sabsender    : byte;          { 0=normal, 1=klein, 2=mit space,   }
       envspace     : word;          { ..3=nur User, 4=Spalten           }
       DefReadmode  : integer;       { Default fr 'readmode' (s.u.) }
       AAmsg        : boolean;       { Auto-Advace }
       AAbrett      : boolean;
       AAuser       : boolean;
       ScrollLock   : boolean;       { umschaltbarer Scroll-Mode }
       GrossWandeln : boolean;       { Adressen in Groschreibung wandeln }
       HaltOwn      : boolean;
       DispUsername : boolean;
       SaveUVS      : boolean;       { AutoPark }
       EmpfBest     : boolean;       { autom. Empfangsbesttigungen }
       EmpfBkennung : string[10];    { '##' }
       unescape     : string[100];   { UUCP-Adressen... }
       ReplaceEtime : boolean;       { 00:00 Erstellungszeit }
       trennchar    : string[1];     { Trennzeichen fr Brett-Trennzeilen }
       AutoArchiv   : boolean;       { automatische PM-Archivierung }
       NewBrettEnde : boolean;       { neue Bretter ans Listenende }
       _maus        : boolean;       { Mausbedienung }
       TrennAll     : boolean;       { Trennzeilen im 'Alle'-Mode }
       BaumAdresse  : boolean;       { volle Adresse im Bezugsbaum }
       SwapMausKeys : boolean;       { Maustasten vertauschen }
       MausDblclck  : byte;          { 4/7/11 }
       MausShInit   : boolean;       { Init nach Shell-Aufruf }
       ConvISO      : boolean;       { ISO-Umlaute im Lister lesbar machen }
       KomArrows    : boolean;       { Kommentarpfeile im Lister anzeigen }
       ListScroller : boolean;       { Scrollbalken bei Mausbedienung }
       ListAutoscroll:boolean;       { Scrolling am Bildschirmrand }
       LargestNets  : integer;       { Conf2: die n grten Netze bei Nodestat }
       NS_MinFlags  : integer;       { Conf2: min. Flags bei Nodestatistik }
       CountDown    : boolean;       { Conf2: Down-Nodes mitzhlen }
       UserBoxname  : boolean;       { Boxname in Userbrettern belassen }
       nDelPuffer   : boolean;       { PUFFER nach Einlesen lschen }
       MaxMaus      : boolean;       { Outfile-Gre begrenzen }
       Auswahlcursor: boolean;       { Blinden-Option }
       Soundflash   : boolean;       { Gehrlosen-Option }
       MausLeseBest : boolean;       { manuelle Maus-Besttigen }
       MausPSA      : boolean;       { Stati anfordern }
       ShowRealnames: boolean;       { Realnames anzeigen, falls vorhanden }
       ss_passwort  : boolean;       { Startpawort nach Screensaver }
       NewsMIME     : boolean;       { MIME auch in News verwenden }
       MIMEqp       : boolean;       { quoted-printable }
       RFC1522      : boolean;       { RFC-1522-Header erzeugen }
       pmlimits     : array[1..maxpmlimits,1..2] of longint;
       ZC_xposts    : boolean;       { ZConnect-Crosspostings }
       ZC_ISO       : boolean;       { ISO-8859-1 verwenden }
       leaveconfig  : boolean;       { /Config-Men bei <Esc> ganz verlassen }
       NewsgroupDisp: boolean;       { Anzeige mit "." statt "/" }
       NetcallLogfile:boolean;       { Logfile ber Netcalls fhren }
       ShrinkUheaders : boolean;     { UUZ-Schalter -r }
       ListHighlight: boolean;       { ** und __ auswerten }
       ListFixedHead: boolean;       { feststehender Nachrichtenkopf }
       MaggiVerkettung: boolean;     { s. xpnt.ntKomkette() }
       ISDN_Int     : byte;          { CAPI-Int, Default=$f1 }
       ISDN_EAZ     : char;          { eigene EAZ, Default='0' }
       ISDN_Controller:byte;         { Nummer des Controllers, Default=0 }
       SaveType     : byte;          { 0=Sofort, 1=Alt-S, 2=Rckfrage }
       XSA_NetAlle  : boolean;       { Netcall/Alle-Schalter bei /Netcall/L }
       maxcrosspost : byte;          { Filter fr Massen-Crosspostings }
       KeepRequests : boolean;       { Requests zurckstellen }
       waehrung     : string[5];
       gebnoconn    : longint;       { Gebhren fr nicht zustandegek. Verb. }
       gebCfos      : boolean;       { Gebhrenbernahme von cFos }
       autofeier    : boolean;       { Feiertage bei Gebhren bercksichtigen }
       ShellShowpar : boolean;       { Anzeige vor Shell-Aufruf }
       ShellWaitkey : boolean;       { warten nach Shell-Aufruf }
       msgbeep      : boolean;       { Tonsignal in N/B/U-bersicht }
       Netcallunmark: boolean;       { Nachrichten nach Netcall ent-markieren }
       DefaultNokop : boolean;       { Default STAT: NOKOP }
       blind        : boolean;       { Anzeigeuntersttzung fr Blinde }
       quotecolors  : boolean;       { verschiedenfarbige Quoteebenenen }
       trennkomm    : byte;          { 1=links, 2=Mitte, 3=rechts }
       vesa_dpms    : boolean;       { Screen-Saver-Stromsparmodus }
       termbios     : boolean;       { BIOS-Ausgabe im Terminal }
       tonsignal    : boolean;       { zustzliches Tonsignal nach Reorg u.a. }
       brettkomm    : boolean;       { Kommetar aus Brettliste bernehmen }
       adrpmonly    : boolean;       { Telefon/Adresse nur in PMs }
       newuseribm   : boolean;       { Default-Umlauteinstellung f. neue User }
       multipartbin : boolean;       { RFC-Binrnachrichten als Multipart }
       mausmpbin    : boolean;       { dto. fr MausTausch }

       UsePGP       : boolean;       { PGP verwenden }
       PGPbatchmode : boolean;       { PGP-Schalter +batchmode verwenden }
       PGP_UUCP     : boolean;       { PGP fr RFC/UUCP }
       PGP_Fido     : boolean;       { PGP fr Fido }
       PGP_UserID   : string[80];    { Netzadresse von Key }
       PGP_AutoPM   : boolean;       { Keys aus PMs automatisch einlesen }
       PGP_AutoAM   : boolean;       { Keys aus AMs automatisch einlesen }
       PGP_waitkey  : boolean;       { 'Taste drcken ...' nach PGP }
       PGP_log      : boolean;       { Logfile fr PGP-Aktivitten }
       PGP_signall  : boolean;       { alle Nachrichten signieren }

       IntVorwahl   : string[15];    { internationale Vorwahl }
       NatVorwahl   : string[10];    { nationale Vorwahl, normalerweise 0 }
       Vorwahl      : string[15];    { eigene Vorwahl }
       AutoDiff     : boolean;       { Node/Pointdiffs automatisch einbinden }
       ShowFidoEmpf : boolean;       { von/an/Betreff-Anzeige }
       HighlightName: string[25];    { eigenen Fido-Brettempfnger hervorheben }
       AutoTIC      : boolean;       { TIC-Files auswerten }

       AutoUpload   : boolean;       { CrossTerm - PD-Zmodem-Autoupload }
       AutoDownload : boolean;       { Autodownload }
       TermCOM      : byte;          { Schnittstelle }
       TermBaud     : longint;       { Baudrate }
       TermStatus   : boolean;       { Statuszeile }
       TermInit     : string[40];    { Modem-Init }

       mono         : boolean;       { monochrome Anzeige      }
       fnkeylines   : byte;          { wird durch DispFunctionKeys gesetzt }
       lesemodepos  : byte;          { X-Position Lesemode }

       orgcbreak    : boolean;
       oldexit      : pointer;       { alte Exit-Prozedur }

       gl,actgl     : shortint;      { Anzeige-Zeilen im Hauptfenster }
       aufbau       : boolean;       { neuer Bildschirm-Aufbau ntig  }
       xaufbau      : boolean;       { Bezugsbaum neu einlesen        }
       readmode     : integer;       { 0=Alles, 1=Ungelesen, 2=Neues }
       readdate     : longint;       { 3=Heute, 4=Datum              }
       nachweiter   : boolean;       { Auto-Advace im Msg-Fenster    }
       brettweiter  : boolean;
       userweiter   : boolean;
       qchar        : string[20];    { zuletzt verwendeter Quote-String }
       brettall     : boolean;       { false -> nur zutreffende Bretter anz. }
       cfgscrlines  : byte;          { Config-Bildzeilen (wg. /z: }
       domainlist   : DomainNodeP;   { zum Erkennen von Replys auf eigene N. }
       DefaultViewer: pviewer;       { Viewer fr */* }
       DefTextViewer: pviewer;       { Viewer fr text/* }
       PtextViewer  : pviewer;       { Viewer fr text/plain }

       maxmark   : word;             { maximal markierbare Msgs }
       marked    : marklistp;        { Liste der markierten Msgs     }
       markanz   : integer;          { Anzahl markierte Msgs         }
       bmarked   : bmarkp;           { Liste der markierten Bretter/User }
       bmarkanz  : integer;          { Anzahl markierte Bretter/User }

       ablsize     : array[0..ablagen-1] of longint;   { Dateigren }
       AktDispmode : shortint;
       AktDisprec  : longint;
       editname    : pathstr;        { Dateiname fr /Edit/Text }
       keymacros   : integer;        { Anzahl geladene Tastenmakros }
       macrokey    : array[1..maxkeys] of taste;
       macroflags  : array[1..maxkeys] of byte;
       macrodef    : array[1..maxkeys] of ^string;
       shortkey    : array[1..maxskeys] of KeyRec;
       shortkeys   : shortint;
       registriert : record r1,r2:boolean; nr:longint;
                            uucp,non_uucp:boolean;
                            tc:char;        { A=normal, B=UUCP, C=komplett }
                            komreg,           { R-Kom / R-Org anzeigen }
                            orgreg:boolean;
                     end;
       regstr1     : string[2];      { mu unmittelbar hinter registriert stehen! }
       regstr2     : string[2];      { fr UUCP }
       AutoCrash   : string[30];     { Crash automatisch starten; *.. -> normaler Netcall }
       ntAllowed   : set of byte;    { zulssige Netztypen }
       extheadersize : integer;      { gre des Kopfes bei xp3.extract_msg() }
       extHdLines  : integer;        { Anzahl Kopfzeilen bei Extrakt mit Kopf }
       fidobin     : boolean;        { Binrnachrichten im FidoNet mglich }
       HeaderLines : integer;        { Def. Anzahl Zeilen bei Extrakt m.Kopf }
       ExtraktHeader : ExtHeaderType;
       reg_hinweis : boolean;        { Fenster bei Programmstart anzeigen }

       PointListn  : string[8];      { alte Pointlisten-Daten }
       PointDiffn  : string[8];
       Pointlist4D : boolean;        { 4D-Liste statt Points24 }

       DefaultZone : word;           { Fido - eigene Zone }
       DefaultNet  : word;           {      - eigenes Net }
       DefaultNode : word;           {      - eigener Node}
       Nodelist    : NL_ap;          { Node-/Pointlisten }
       NL_anz      : byte;           { Anzahl " }
       NodeOpen    : boolean;        { Nodelist(en) vorhanden & geffnet }
       ShrinkNodes : string[100];    { Nodeliste einschrnken }
       kludges     : boolean;        { ^A-Zeilen im Lister anzeigen }
       KomShowadr  : boolean;        { <-> BaumAdresse }
       gAKAs       : ^string;        { globale AKA-Adressliste }
       Orga        : ^OrgStr;
       Postadresse : ^string;
       TelefonNr   : ^TeleStr;
       wwwHomepage : ^HomepageStr;
       BrettAlle   : string[20];     { Standardempfnger fr Brettnachrichten }
       fidoto      : string[35];     { XP6: Empfngername bei Brettnachr.     }
       FidoDelEmpty: boolean;        { 0-Byte-Nachrichten lschen }
       KeepVia     : boolean;        { ZFIDO: Option -via }

       kombaum     : komlistp;       { Kommentarbaum }
       komanz      : word;           { Anzahl Eintrge }
       maxebene    : shortint;
       komwidth    : shortint;       { Anzeigeabstand zwischen Ebenen }
       kombrett    : string[5];      { Brettcode der Ausgangsnachricht }

       languageopt : boolean;        { /Config/Optionen/Sprachen }
       _fehler_    : string[12];
       _hinweis_   : string[12];
       _days_      : ^string;        { 'Monatag Dienstag ... ' }
       _daylen_    : word;
       StatBrett,                    { /Statistik  }
       UnvBrett,                     { /Unversandt }
       NetBrett    : string[15];     { /Netzanruf  }
       _wotag_     : string[14];     { 'MoDiMiDoFrSaSo' }
       _jn_        : string[2];      { 'JN' }


implementation

end.
